

package com.sapmarkets.technology.util.reg;


public abstract class Registration {

  protected volatile int    count;

  public Registration()
  { this(null);
  }

  public Registration(Object o)
  { this.count=0;
    setObject(o);
  }

  synchronized
  protected void inc()
  { count++;
    if (count==1) RegistrationDestination.notifyRegistration(this);
  }

  synchronized
  protected void dec()
  { if (count>0) {
      count--;
      if (count<=0) {
	RegistrationDestination.notifyUnRegistration(this);
      }
    }
  }

  public abstract Object getObject();
  protected abstract void setObject(Object o);

  public int getRegistrationCount()
  { return count;
  }

  synchronized
  final public void unregister()
  { 
    handleUnregister();
    if (count>0) {
      System.err.println("ERROR: registration not fully unregistered "+this);
      RegistrationDestination.notifyUnRegistration(this);
    }
    count=0;
  }

  abstract protected void handleUnregister();

  public void finalize() throws Throwable
  { finish(); 
  }

  synchronized
  public void finish()
  { if (count>0) {
      RegistrationDestination.notifyUnRegistration(this);
      count=0;
    }
  }
}
