

package com.sapmarkets.technology.util.reg;


public abstract class AbstractRegisteredObjectHandle {

  private Registration reg=new Registration() {
    protected void handleUnregister()
    { dec();
      notifyUnregister();
      setObject(null);
    }

    public Object getObject()
    { return get();
    }

    protected void setObject(Object o)
    { set(o);
    }
  };

  public AbstractRegisteredObjectHandle()
  { this(null);
  }

  public AbstractRegisteredObjectHandle(Object o)
  { setObject(o);
  }

  protected abstract void set(Object o);
  protected abstract Object get();

  synchronized
  public Object getObject()
  { Object o;

    if (reg.getObject()==null) {
      o=restoreObject();
      if (o!=null) setObject(o);
    }
    return get();
  }

  synchronized
  public void setObject(Object o)
  { 
    if (reg.getRegistrationCount()>0) RegistrationDestination.dec(reg);
    set(o);
    if (get()!=null) RegistrationDestination.inc(reg);
  }


  synchronized
  public boolean valid()
  { if (get()!=null) return true;
    if (reg.getRegistrationCount()>0) RegistrationDestination.dec(reg);
    return false;
  }

  /**
   * restore an object from abstract handle data.
   * This method may be implemented by sub classes that provide
   * abstract object information that can be used to automatically
   * restore an object if it is flushed.
   */
  protected Object restoreObject()
  { return null;
  }

  /**
   * notify the handle about unregistration of the refered object.
   */
  protected void notifyUnregister()
  {
  }
}
