
package com.sapmarkets.technology.util;

import java.util.Hashtable;
import java.util.Enumeration;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public class WeakHashTable {
  private ReferenceQueue queue;
  private Hashtable      hash;
  private Hashtable      ref_hash;

  public WeakHashTable()
  { queue=new ReferenceQueue();
    hash =new Hashtable();
    ref_hash =new Hashtable();
  }

  private void removeRef(Reference r)
  { Object k=ref_hash.get(r);
//    System.out.println("removing ref "+r);
    if (k!=null) {
      hash.remove(k);
//      System.out.println("removing entry for "+k);
    }
    ref_hash.remove(r);
  }

  private void addRef(Object key, Object value)
  { Reference r=new WeakReference(value,queue);
    ref_hash.put(r,key);
    hash.put(key,r);
  }

  synchronized
  public Object get(Object key)
  { Reference e;
    Object obj=null;

    while ((e=queue.poll())!=null) {
//      System.out.println("poll "+e);
      removeRef(e);
    }
  
    e=(Reference)hash.get(key);

    if (e!=null) {
      if ((obj=e.get())==null) {
	removeRef(e);
      }
    }
    return obj;
  }

  synchronized
  public void put(Object key, Object value)
  { addRef(key, value);
  }

  synchronized
  public void remove(Object key)
  { Object r=hash.get(key);
    if (r!=null) ref_hash.remove(r);
    hash.remove(key);
  }

  synchronized
  public void clear()
  { hash.clear();
    ref_hash.clear();
  }

  public Enumeration elements()
  { return new WeakEnumeration();
  }

  private class WeakEnumeration implements Enumeration {
    Enumeration e=((Hashtable)hash.clone()).elements();
    Object o;

    Object next()
    { Reference r;

      while ((r=queue.poll())!=null) {
        removeRef(r);
      }
      while (e.hasMoreElements()) {
	r=(Reference)e.nextElement();
	if ((o=r.get())!=null) return o;
	else removeRef(r);
      }
      return o=null;
    }

    WeakEnumeration()
    { next();
    }

    public boolean hasMoreElements()
    { return o!=null;
    }

    public Object nextElement()
    { Object r=o;
      next();
      return r;
    }
  }
}
