
package com.sapmarkets.technology.util;


import java.util.Collection;
import java.util.WeakHashMap;
import java.util.Iterator;
import java.util.AbstractSet;

public class WeakHashSet extends AbstractSet {
  private WeakHashMap map=new WeakHashMap();


  public WeakHashSet()
  { super();
  }

  public WeakHashSet(Collection c)
  { super();
    Iterator i=c.iterator();
    while (i.hasNext()) {
      add(i.next());
    }
  }

  public boolean add(Object o)
  { boolean b=contains(o);
    if (!b) map.put(o,null);
    return !b;
  }

  public boolean remove(Object o)
  { boolean b=contains(o);
    map.remove(o);
    return b;
  }

  public boolean contains(Object o)
  { return map.containsKey(o);
  }

  public int size()
  { return map.size();
  }

  public void clear()
  { map.clear();
  }

  public Iterator iterator()
  { return map.keySet().iterator();
  }
}

/*
import java.util.HashMap;
import java.util.Iterator;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public class WeakHashSet {
  private ReferenceQueue queue;
  private HashMap        hash;
  private HashMap        ref_hash;

  public WeakHashSet()
  { queue=new ReferenceQueue();
    hash =new HashMap();
    ref_hash =new HashMap();
  }

  private static class Entry {
    Reference ref;
    int hashcode;
    Object object; // only for contains test

    Entry(Object o, ReferenceQueue queue)
    { ref=new WeakReference(o,queue);
      hashcode=o.hashCode();
      object=null;
    }

    Entry()
    { ref=null;
      hashcode=0;
      object=null;
    }

    void setObject(Object o)
    { object=o;
      hashcode=o==null?0:o.hashCode();
    }

    public int hashCode()
    { return hashcode; // keep hashcode always the same
    }
  
    public boolean equals(Object obj)
    { 
      if (obj==this) return true;
      if (obj instanceof Entry) {
	Object o;
	if (object!=null) { // handle compare object
	  o=object;
	}
	else { // handle regular object
	  o=ref.get();
	}
	if (o!=null && o==((Entry)obj).ref.get()) return true;
	// if object has vanished shift qualtity to reference equivalence
	return ref==((Entry)obj).ref;
      }
      return false;
    }

  }

  private Entry dummy=new Entry();

  private void removeRef(Reference r)
  { Entry k=(Entry)ref_hash.get(r);
    // System.out.println("removing ref "+r);
    removeEntry(r,k);
  }

  private void removeEntry(Reference r, Entry k)
  {
    if (k!=null) {
      hash.remove(k);
      // System.out.println("removing entry for "+k);
    }
    ref_hash.remove(r);
  }

  private void addRef(Object value)
  { Entry e=new Entry(value,queue);
    Reference r=e.ref;
    ref_hash.put(r,e);
    hash.put(e,e);
  }

  private void poll()
  { Reference r;
    while ((r=queue.poll())!=null) {
      // System.out.println("poll "+r);
      removeRef(r);
    }
  
  }

  synchronized
  public boolean contains(Object value)
  { Object obj=null;

    poll();

    dummy.setObject(value);
    Entry e=(Entry)hash.get(dummy);

    if (e!=null) {
      if (e.ref.get()!=null) return true;
      removeEntry(e.ref,e);
    }
    return false;
  }

  synchronized
  public boolean add(Object value)
  { if (!contains(value)) {
      addRef(value);
      return true;
    }
    return false;
  }

  synchronized
  public boolean remove(Object value)
  { 
    dummy.setObject(value);
    Entry e=(Entry)hash.get(dummy);
    if (e!=null) {
      removeEntry(e.ref,e);
      if (e.ref.get()!=null) return true; // should always be true
    }
    return false;
  }

  synchronized
  public void clear()
  { hash.clear();
    ref_hash.clear();
  }

  synchronized
  public Iterator iterator()
  { return new WeakIterator();
  }

  private class WeakIterator implements Iterator {
    Iterator i;
    Object o;
    Entry e;

    void _next()
    {
      while (i.hasNext()) {
	e=(Entry)i.next();
	if ((o=e.ref.get())!=null) return;
	// System.out.println("    remove "+e);
	i.remove();
	ref_hash.remove(e.ref);
      }
      o=null;
      e=null;
    }

    WeakIterator()
    { 
      poll();
      i=hash.keySet().iterator();
      _next();
    }

    public boolean hasNext()
    { return o!=null;
    }

    public Object next()
    { Object r=o;
      _next();
      return r;
    }

    public void remove()
    { i.remove();
      ref_hash.remove(e.ref);
    }
  }
}
*/
