package com.sapmarkets.technology.util;

import java.util.Properties;
import java.util.Enumeration;
import java.lang.reflect.Constructor;

public class Util {

  /**
   * get property subset.
   * Extract a set of properties with the syntax
   * <code>prefix./something/></code>.
   * The found properties are returned in a Properties object without the
   * prefix.
   */
  static public Properties getProperties(Properties props, String prefix)
  { Enumeration e=props.keys();
    Properties  n=new Properties();
    int l;
    
    if (!prefix.endsWith(".")) prefix+=".";
    l=prefix.length();

    while (e.hasMoreElements()) {
      String name=(String)e.nextElement();
      if (name.startsWith(prefix)) {
	n.put(name.substring(l),props.getProperty(name));
      }
    }
    return n;
  }

  /**
   * evaluate a boolean switch state
   */
  static public boolean getSwitch(String name)
  { return getSwitch(name,false);
  }

  /**
   * evaluate a boolean switch state
   */
  static public boolean getSwitch(String name, boolean def)
  {
    if (name==null) return def;
    name=name.toLowerCase();
    if (name.equals("on") || name.equals("true")) {
      return true;
    }
    else {
      try {
	return (Integer.parseInt(name)!=0);
      }
      catch (Exception e) {}
    }
    return false;
  }

  /**
   * create an object out of a property set.
   * The property set must at least contain the property
   * <code>class</code>. Additional properties will be passed
   * to the constructor of the given class if it defines
   * a constructor accepting a <code>Properties</code> parameter.
   * Otherwise the parameterless constructor will be used.
   * To instantiate the class, the class loader of this class will be used.
   * @param props  property set to use for object creation.
   */
  static public Object createObject(Properties props)
  { return createObject(props, null);
  }

  /**
   * create an object out of a property set.
   * The property set must at least contain the property
   * <code>class</code>. Additional properties will be passed
   * to the constructor of the given class if it defines
   * a constructor accepting a <code>Properties</code> parameter.
   * Otherwise the parameterless constructor will be used.
   * @param props  property set to use for object creation.
   * @param loader class loader to use for class lookup.
   */
  static public Object createObject(Properties props, ClassLoader loader)
  { String cn=props.getProperty("class");
    if (cn==null) return null;

    try {
      Class c;
      Constructor cr;

      if (loader==null) c=Class.forName(cn);
      else              c=loader.loadClass(cn);
      try {
	cr=c.getConstructor(new Class[]{Properties.class,ClassLoader.class});
	return cr.newInstance(new Object[]{props,loader});
      }
      catch (Exception e1) {
	try {
	  cr=c.getConstructor(new Class[]{Properties.class});
	  return cr.newInstance(new Object[]{props});
	}
	catch (Exception e2) {
	}
      }
      try {
	return c.newInstance();
      }
      catch (Exception e1) {
	return null;
      }
    }
    catch (Exception e) {
      return null;
    }
  }
}
