/*
 * SAPMarkets Copyright (c) 2001
 * All rights reserved
 *
 * @version $Id$
 */

package com.sapmarkets.technology.util;

import java.util.*;

/**
 * Class defining a time stamp used to meassure time differences in execution time.
 *
 * @created   25. April 2001
 */
public class TimeStamp
{
    Date date = null;

    /**
     * Construct and thereby initialize timer to the actual time.
     */
    public TimeStamp()
    {
        date = new Date();
    }

    /**
     * Construct timer with specified time.
     *
     * @param date  initial time stamp
     */
    public TimeStamp( Date date )
    {
        this.date = date;
    }

    /**
     * Get time of construction/reset of the time stamp
     *
     * @return   time of construction/reset of the time stamp in milliseconds
     */
    public long getTime()
    {
        return date.getTime();
    }

    /**
     * Get time difference between construction/reset of the time stamp and the actual time
     *
     * @return   time difference between construction/reset of the time stamp and the actual time in
     *      milliseconds
     */
    public long getTimeDiff()
    {
        return new Date().getTime() - date.getTime();
    }

    /**
     * Reset timer to the actual time.
     */
    public void reset()
    {
        date = new Date();
    }
}
