/*
 * SAP Copyright (c) 2002
 * All rights reserved
 *
 * @version $Id$
 */

package com.sapmarkets.technology.util;

import java.util.*;

/**
 * Interface describing internationalized access to messages, dates, numbers, etc. When calling the
 * member functions without a locale/timezone, the default context locale/timezone will be assumed
 * otherwise the explicit given locale/timezone will be used. You may retrieve an i18n environment
 * for convenience which is fixed to use the locale/timezone used during it's instantiation.
 *
 * @created   10. September 2001
 */
public interface II18NMgmt
{
    /**
     * Initialize i18n management.
     *
     * @param locale    locale specific to this i18n environment
     * @param timezone  timezone specific to this i18n environment
     */
    public void init( Locale locale, TimeZone timezone );

    /**
     * Get instance of i18n environment bound to the default locale/timezone.
     *
     * @return   i18n environment
     */
    public II18NEnv getI18NEnvInstance();

    /**
     * Get instance of i18n environment bound to specific locale/the default timezone.
     *
     * @param locale  locale to bind i18n environment to
     * @return        i18n environment
     */
    public II18NEnv getI18NEnvInstance( Locale locale );

    /**
     * Get instance of i18n environment bound to specific locale/timezone.
     *
     * @param locale    locale to bind i18n environment to
     * @param timezone  timezone to bind i18n environment to
     * @return          i18n environment
     */
    public II18NEnv getI18NEnvInstance( Locale locale, TimeZone timezone );

    /**
     * Get the default locale.
     *
     * @return   default locale
     */
    public Locale getDefaultLocale();

    /**
     * Get the default timezone.
     *
     * @return   default timezone
     */
    public TimeZone getDefaultTimezone();
}
