/*
 * SAPMarkets Copyright (c) 2001
 * All rights reserved
 *
 * @version $Id$
 */

package com.sapmarkets.technology.util;

import java.io.*;

/**
 * Class defining an abstract observer which will be called if provided with observable file based
 * operations.
 *
 * @created   30. Oktober 2001
 */
public abstract class FilesObserver implements IFilesObserver
{
    /**
     * Called before source file will be copied to destination file.
     *
     * @param srcFile   source file
     * @param destFile  destination file
     */
    public void onCopyFileInvoke( File srcFile, File destFile )
    {
        ;
    }

    /**
     * Called after source file was copied to destination file.
     *
     * @param srcFile   source file
     * @param destFile  destination file
     */
    public void onCopyFileProcessed( File srcFile, File destFile )
    {
        ;
    }

    /**
     * Called before file will be deleted.
     *
     * @param file  file to be deleted
     */
    public void onDeleteFileInvoke( File file )
    {
        ;
    }

    /**
     * Called after file was deleted.
     *
     * @param file  deleted file
     */
    public void onDeleteFileProcessed( File file )
    {
        ;
    }

    /**
     * Called before source file will be synchronized with destination file.
     *
     * @param srcFile   source file
     * @param destFile  destination file
     */
    public void onSyncFileInvoke( File srcFile, File destFile )
    {
        ;
    }

    /**
     * Called after source file was synchronized with destination file.
     *
     * @param srcFile   source file
     * @param destFile  destination file
     */
    public void onSyncFileProcessed( File srcFile, File destFile )
    {
        ;
    }
}
