/*
 * SAPMarkets Copyright (c) 2001
 * All rights reserved
 *
 * @version $Id: //sapmarkets/BaseTech/630_VAL_REL/src/_util/java/com/sapmarkets/technology/exc/RuntimeException.java#1 $
 */

package com.sapmarkets.technology.exc;

public class RuntimeException extends java.lang.RuntimeException
{
  private Throwable exception = null;

  public RuntimeException()
  {
    super();
  }

  public RuntimeException( String message )
  {
    super(message);
  }

  public RuntimeException(Throwable exception)
  {
    super();
    this.exception = exception;
  }

  public RuntimeException(String message, Throwable exception )
  {
    super(message);
    this.exception = exception;
  }

  public Throwable getInitiatingException()
  {
    return exception;
  }

  public String toString()
  { String msg=super.toString();

    if (exception!=null) {
      msg=msg+" on behalf of "+exception.toString();
    }
    return msg;
  }

  public void printStackTrace()
  {
    printStackTrace(System.out);
  }

  public void printStackTrace(java.io.PrintStream s)
  { CallStack.Combine c=new CallStack.Combine(exception);

    super.printStackTrace(c);
    c.printStackTrace(s);
  }

  public void printStackTrace(java.io.PrintWriter s)
  { CallStack.Combine c=new CallStack.Combine(exception);

    super.printStackTrace(c);
    c.printStackTrace(s);
  }
}
