/*
 * SAPMarkets Copyright (c) 2001
 * All rights reserved
 *
 * @version $Id: //sapmarkets/BaseTech/630_VAL_REL/src/_util/java/com/sapmarkets/technology/exc/Exception.java#1 $
 */

package com.sapmarkets.technology.exc;

public class Exception extends java.lang.Exception
{
  private Throwable exception = null;

  public Exception()
  {
    super();
  }

  public Exception( String message )
  {
    super(message);
  }

  public Exception(Throwable exception)
  {
    super();
    this.exception = exception;
  }

  public Exception(String message, Throwable exception )
  {
    super(message);
    this.exception = exception;
  }

  public Throwable getInitiatingException()
  {
    return exception;
  }

  public String toString()
  { String msg=super.toString();

    if (exception!=null) {
      msg=msg+" on behalf of "+exception.toString();
    }
    return msg;
  }

  public void printStackTrace()
  {
    printStackTrace(System.out);
  }

  public void printStackTrace(java.io.PrintStream s)
  { CallStack.Combine c=new CallStack.Combine(exception);

    super.printStackTrace(c);
    c.printStackTrace(s);
  }

  public void printStackTrace(java.io.PrintWriter s)
  { CallStack.Combine c=new CallStack.Combine(exception);

    super.printStackTrace(c);
    c.printStackTrace(s);
  }
}
