package com.sapmarkets.technology.exc;

import java.io.StringWriter;
import java.io.PrintWriter;
import java.io.PrintStream;
import java.util.Vector;
import java.text.BreakIterator;

public class CallStack {

  static class Combine extends PrintWriter {
    Throwable slave;

    Combine(Throwable slave)
    { super(new StringWriter());
      this.slave=slave;
    }

    public void printStackTrace(PrintWriter w)
    { int i;

      if (slave!=null) {
	Vector v1=new Vector();
	Vector v2=new Vector();
	Vector c=new Vector();
	diff(get(out.toString()),slave,v1,v2,c);
	for (i=0; i<v1.size(); i++) {
	  w.println(v1.elementAt(i));
	}

	w.print("    on behalf of ");
	for (i=0; i<v2.size(); i++) {
	  w.println(v2.elementAt(i));
	}

	w.println("    common part of stack");
	for (i=0; i<c.size(); i++) {
	  w.println(c.elementAt(i));
	}
      }
      else {
	w.print(out.toString());
      }
    }
    
    public void printStackTrace(PrintStream w)
    { int i;

      if (slave!=null) {
	Vector v1=new Vector();
	Vector v2=new Vector();
	Vector c=new Vector();
	diff(get(out.toString()),slave,v1,v2,c);
	for (i=0; i<v1.size(); i++) {
	  w.println(v1.elementAt(i));
	}

	w.print("    on behalf of ");
	for (i=0; i<v2.size(); i++) {
	  w.println(v2.elementAt(i));
	}

	w.println("    common part of stack");
	for (i=0; i<c.size(); i++) {
	  w.println(c.elementAt(i));
	}
      }
      else {
	w.print(out.toString());
      }
    }
  }

  static public Vector get()
  { return get(new Throwable());
  }


  static public Vector get(Throwable t)
  { StringWriter  sw=new StringWriter();
    Vector        v =new Vector();
    String        s;
    int           p;
    int           l=0;

    t.printStackTrace(new PrintWriter(sw));
    return get(sw.toString());
  }

  static public Vector get(String s)
  { 
    Vector        v =new Vector();
    int           p;
    int           l=0;

    while ((p=s.indexOf('\n',l))>=0) {
      v.add(s.substring(l,p));
      l=p+1;
    }
    return v;
  }


  static public void diff(Throwable t1, Throwable t2, 
			  Vector p1, Vector p2, Vector c)
  { Vector v1=get(t1);
    diff(v1,t2,p1,p2,c);
  }

  static public void diff(Vector v1, Throwable t2, 
			  Vector p1, Vector p2, Vector c)
  { Vector v2=get(t2);
    int    i1=v1.size()-1;
    int    i2=v2.size()-1;
    int    i;
    

    while (i1>=0 && i2>=0 && v1.elementAt(i1).equals(v2.elementAt(i2))) {
      i1--;
      i2--;
    }

    // extract common part
    c.clear();
    for (i=i1+1; i<v1.size(); i++) {
      c.add(v1.elementAt(i));
    }

    // extract diff parts
    p1.clear();
    for (i=0; i<=i1; i++) {
      p1.add(v1.elementAt(i));
    }
    p2.clear();
    for (i=0; i<=i2; i++) {
      p2.add(v2.elementAt(i));
    }
  }

  static public void printStackTrace(Throwable t1, Throwable t2)
  {
    printStackTrace(t1,t2,System.out);
  }

  static public void printStackTrace(Throwable t1, Throwable t2, PrintWriter w)
  { int i;

    if (t2!=null) {
      Vector v1=new Vector();
      Vector v2=new Vector();
      Vector c=new Vector();
      diff(t1,t2,v1,v2,c);
      for (i=0; i<v1.size(); i++) {
	w.println(v1.elementAt(i));
      }

      w.print("    on behalf of ");
      for (i=0; i<v2.size(); i++) {
	w.println(v2.elementAt(i));
      }

      w.println("    common part of stack");
      for (i=0; i<c.size(); i++) {
	w.println(c.elementAt(i));
      }
    }
    else {
      t1.printStackTrace(w);
    }
  }

  static public void printStackTrace(Throwable t1, Throwable t2, PrintStream w)
  { int i;

    if (t2!=null) {
      Vector v1=new Vector();
      Vector v2=new Vector();
      Vector c=new Vector();
      diff(t1,t2,v1,v2,c);
      for (i=0; i<v1.size(); i++) {
	w.println(v1.elementAt(i));
      }

      w.print("    on behalf of ");
      for (i=0; i<v2.size(); i++) {
	w.println(v2.elementAt(i));
      }

      w.println("    common part of stack");
      for (i=0; i<c.size(); i++) {
	w.println(c.elementAt(i));
      }
    }
    else {
      t1.printStackTrace(w);
    }
  }
}
