/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.notificator;
import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.service.IService;

import com.sapportals.wcm.util.channels.IChannel;
import com.sapportals.wcm.util.channels.IRecipient;
import com.sapportals.wcm.util.channels.IRecipientList;

import java.util.Collection;

/**
 * Interface to the notification service. <p>
 *
 * A notificator allows the sending of <i>notification</i> s to a <i>recipient
 * </i> via a given <i>channel</i> . <br>
 * A notification represents some kind of message (e.g. a html-text). A
 * recipient is a destination (e.g. a person) to send the message to. The
 * channel specifies the transport mechanism to use (e.g. eMail). <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author andreas.heix@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/service/notificator/api/com/sapportals/wcm/service/notificator/INotificator.java#4
 *      $
 */
public interface INotificatorService extends IService {
  // ---------
  // Constants ----------------------------------------------------------------
  // ---------

  /**
   * default encoding to use, when transforming Streams into Strings. Used, when
   * the IContent object doesn't specify its encoding
   */
  public final static String ENCODING_DEFAULT = "UTF-8"; // changed from "ISO-8859-1" at 2004/06/08

  /**
   * id for SUBSCRIPTION notificiation: a subscription generated an event.
   */
  public final static String SUBSCRIPTION_NOTIFICATION = "SUBSCRIPTION";

  /**
   * id for SUBSCRIPTIONBUNDLED notificiation: a polling event trigged one or
   * more notifications.
   */
  public final static String SUBSCRIPTIONBUNDLED_NOTIFICATION = "SUBSCRIPTIONBUNDLED";

  /**
   * id for SUBSCRIPTIONADMIN notification: a subscription was created/deleted
   * or resources have been added to / removed from a subscription.
   */
  public final static String SUBSCRIPTIONADMIN_NOTIFICATION = "SUBSCRIPTIONADMIN";

  /**
   * id for WORKFLOW notification: a document state changed and someone has to
   * do something (a workflow task is started)...
   */
  public final static String WORKFLOW_NOTIFICATION = "WORKFLOW";

  /**
   * id for WORKFLOWRESULT notification: someone did something with a workflow
   * document (a workflow task is completed).
   */
  public final static String WORKFLOWRESULT_NOTIFICATION = "WORKFLOWRESULT";

  /**
   * Get a list of available channels for this notificator.
   *
   * @return <code>Collection</code> is a list of <code>IChannel</code> s with
   *      the valid channels for this notificator.
   * @exception WcmException Exception raised in failure situation
   * @throws WcmException if the list of channels can't be
   *      retrieved.
   */
  public Collection getChannels()
    throws WcmException;

  /**
   * Send a notification to a recipient via the specified channel.
   *
   * @param recipient TBD: Description of the incoming method parameter
   * @param channel TBD: Description of the incoming method parameter
   * @param notification TBD: Description of the incoming method parameter
   * @exception WcmException Exception raised in failure situation
   * @throws WcmException if the notification could not be sent.
   */
  public void send(
    IRecipient recipient,
    IChannel channel,
    INotification notification)
    throws WcmException;

  public void send(
    IRecipientList recipients,
    IChannel channel,
    INotification notification)
    throws WcmException;


  /**
   * Get the default from address for a channel.
   *
   * @param channel a <code>IChannel</code> to get the address for.
   * @return a <code>String</code> with the from address for the given channel.
   * @exception WcmException Exception raised in failure situation
   */
  public String getDefaultFromAddress(IChannel channel)
    throws WcmException;

}

// EOF
