/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.notificator;
import com.sapportals.wcm.WcmException;

import com.sapportals.wcm.util.channels.IChannel;
import com.sapportals.wcm.util.channels.IRecipient;
import com.sapportals.wcm.util.content.IContent;

import java.lang.String;
import java.util.Locale;
import java.util.Properties;

/**
 * This interface defines the <i>notification</i> s send by a <i>notificator</i>
 * . <p>
 *
 * A notificaton represents some kind of 'form', e.g. a subscription
 * notification. The layout (content) of this form (notification) might depend
 * on the recipient and channel. <br>
 * For example: a subscription notification, wich should be send to a german
 * recipient by eMail should have some german html-content, while a subscription
 * notification for an english recipient by SMS should have plain english text.
 * <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author andreas.heix@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/service/notificator/api/com/sapportals/wcm/service/notificator/INotification.java#8
 *      $
 */
public interface INotification {

  /**
   * Get a system id for this notification. For example '<code>subscription
   * </code>' for a subcription notification.
   *
   * @return <code>String</code> is the system id.
   */
  public String getID();

  /**
   * Get a displayable name (title). For example '<i>Subscription Notification
   * </i>' for a suscription notification.
   *
   * @return <code>String</code> is the displayable name.
   */
  public String getDescription();

  /**
   * Get a displayable name (title) for a specific locale.
   *
   * @param locale TBD: Description of the incoming method parameter
   * @return <code>String</code> is the displayable name for the given locale.
   */
  public String getDescription(Locale locale);

  /**
   * Get the 'from' address for a specific channel.
   *
   * @param channel a <code>IChannel</code> with the channel to get the from
   *      address for.
   * @return a <code>String</code> with from address for the given channel.
   */
  public String getFromAddress(IChannel channel);

  /**
   * Get the content (depending on recipient and channel).
   *
   * @param recipient TBD: Description of the incoming method parameter
   * @param channel TBD: Description of the incoming method parameter
   * @param properties TBD: Description of the incoming method parameter
   * @return <code>IContent</code> is the content, wich should depend on the
   *      specified channel and the given recipient (e.g. content can differ for
   *      WAP- and eMail-channels, or it may depend on the receivers locale).
   * @exception WcmException Exception raised in failure situation
   */
  public IContent getContent(IRecipient recipient,
    IChannel channel,
    Properties properties)
    throws WcmException;

}

// EOF
