package com.sap.caf.mp.mmr.ejb;
import java.util.Enumeration;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.core.data.mapping.api.IMappingRule;
import com.sap.caf.mp.core.data.mapping.api.ISimpleMappingService;
import com.sap.caf.mp.core.data.mmr.IDataServiceFactoryInit;
import com.sap.caf.mp.core.data.persistence.api.ISimpleServiceDescriptionPersistence;
import com.sap.caf.mp.core.data.service.IDataServiceFactory;
import com.sap.caf.mp.core.data.service.interfce.api.IPorttype;
import com.sap.caf.mp.core.data.service.registry.IServiceDefinition;
import com.sap.caf.mp.core.data.service.registry.ISimpleServicesRegistry;
import com.sap.caf.mp.core.data.types.api.IMessage;
import com.sap.caf.mp.mmr.adapter.MMServiceRetrievalAdapter;


/**
 * @ejbLocal <{com.sap.caf.mp.mmr.ejb.MMServiceRetrievalAdapterCallerLocal}>
 * @ejbLocalHome <{com.sap.caf.mp.mmr.ejb.MMServiceRetrievalAdapterCallerLocalHome}>
 * @stateless 
 */
public class MMServiceRetrievalAdapterCallerBean implements SessionBean, ISimpleServicesRegistry, ISimpleServiceDescriptionPersistence, ISimpleMappingService {
	
	private static final long serialVersionUID = 1;
	
	private transient MMServiceRetrievalAdapter mAdapter;
	
	public void ejbRemove() {
	}

	public void ejbActivate() {
	}

	public void ejbPassivate() {
	}

	public void setSessionContext(SessionContext context) {
		myContext = context;
	}

	private transient SessionContext myContext;
	
	/**
	 * Create Method.
	 */
	public void ejbCreate() throws CreateException {
		try {
			Class c = Class.forName("com.sap.caf.mp.mmr.adapter.MMServiceRetrievalAdapter");
			Object obj = c.newInstance();
			mAdapter = new MMServiceRetrievalAdapter();
		}
		catch( Exception ex ) {
			throw new EJBException(ex);	// $JL-EXC$
		}
	}

	/**
	 * @see com.sap.caf.mp.core.data.service.registry.ISimpleServicesRegistry#getServiceDefinitionIds()
	 */
	public Enumeration getServiceDefinitionIds() throws EngineException {
		try {
			return mAdapter.getServiceDefinitionIds();
		}
		catch(EngineException ex ) {
			ex.printStackTrace();
			throw( ex );
		}
		
	}

	/**
	 * @see com.sap.caf.mp.core.data.service.registry.ISimpleServicesRegistry#readServiceDefinition(java.lang.String)
	 */
	public IServiceDefinition readServiceDefinition(String id)
		throws InvocationException, EngineException {
		return mAdapter.readServiceDefinition(id);
	}

	/**
	 * @see com.sap.caf.mp.core.data.persistence.api.ISimpleServiceDescriptionPersistence#getMessageIds()
	 */
	public Enumeration getMessageIds() throws EngineException {
		try {
			return mAdapter.getMessageIds();
		}
		catch(Exception ex ) {
			ex.printStackTrace();
			throw( new EngineException( ex ) );
		}
	}

	/**
	 * @see com.sap.caf.mp.core.data.persistence.api.ISimpleServiceDescriptionPersistence#getPorttypeIds()
	 */
	public Enumeration getPorttypeIds() throws EngineException {
		return mAdapter.getPorttypeIds();
	}

	/**
	 * @see com.sap.caf.mp.core.data.persistence.api.ISimpleServiceDescriptionPersistence#readMessage(java.lang.String)
	 */
	public IMessage readMessage(String id)
		throws InvocationException, EngineException {
		return mAdapter.readMessage(id);
	}

	/**
	 * @see com.sap.caf.mp.core.data.persistence.api.ISimpleServiceDescriptionPersistence#readPorttype(java.lang.String)
	 */
	public IPorttype readPorttype(String id)
		throws InvocationException, EngineException {
		return mAdapter.readPorttype(id);
	}

	/**
	 * @see com.sap.caf.mp.core.data.mapping.api.ISimpleMappingService#readMappingRule(java.lang.String)
	 */
	public IMappingRule readMappingRule(String id)
		throws InvocationException, EngineException {
		return mAdapter.readMappingRule(id);
	}

	/**
	 * @see com.sap.caf.mp.core.data.mapping.api.ISimpleMappingService#readMappingRuleIds()
	 */
	public Enumeration readMappingRuleIds() throws EngineException {
		return mAdapter.readMappingRuleIds();
	}

}
