package com.sap.tc.webdynpro.services.session.api;

import com.sap.tc.webdynpro.services.session.ScopeType;

/**
 * @author SAP
 * @SAPWebDynproPart 2
 *
 * WDScopeType represents a type safe ID for Scopes. 
 * The available WDScopeType instances are defined in IScope
 */
public final class WDScopeType extends ScopeType{
  /**
   * Task Scope => scope lives during a single request/response cycle
   */
  static public final WDScopeType TASK_SCOPE = new WDScopeType("TASK_SCOPE");

  /**
   * Server Session Scope.
   */
  static public final WDScopeType SERVERSESSION_SCOPE = new WDScopeType("SERVERSESSION_SCOPE");

  /**
   * Client Session Scope.
   */
  static public final WDScopeType CLIENTSESSION_SCOPE = new WDScopeType("CLIENTSESSION_SCOPE");
  /**
   * Scope Application.
   */
  static public final WDScopeType APPLICATION_SCOPE = new WDScopeType("APPLICATION_SCOPE");

  /**
   * Scope VM.
   */
  static public final WDScopeType VM_SCOPE = new WDScopeType("VM_SCOPE");


  /**
   * default constructor
   * @param value
   */
  private WDScopeType(String value) {
    super(value);
  }

}
