/*
 * SAP Copyright (c) 2003
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/session/api/IWDWindow.java#2 $
 */
package com.sap.tc.webdynpro.services.session.api;


/**
 * Application API for windows
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDWindow {
  public static final String WINDOW_LEFT_POSITION = "left";
  public static final String WINDOW_RIGHT_POSITION = "right";  
  public static final String WINDOW_TOP_POSITION = "top";
  public static final String WINDOW_BOTTOM_POSITION = "bottom";
  public static final String WINDOW_POSITION_CENTERED = "WINDOW_CENTER";
  
  /**
   * Method close - closes the window but the instance is not destroyed -> reopen is possible.
   */
  public void close(); 
  
  /**
   * Method isTopLevel - returns if the window is the root window.
   * @return boolean - true if it is root window
   */
  public boolean isTopLevel();
  
  /**
   * Method isModal - checks if the window is modal.
   * @return boolean - true if it is modal
   */
  public boolean isModal();
  
  /**
   * Method setWindowSize - sets the window size in "px". As default values the maximum is set.
   * @param width - the width of the window
   * @param height - the height ot the window
   */
  public void setWindowSize(int width, int height);

  /**
   * Method setWindowSize - sets the window size. As default values the maximum is set.
   * @param width - the width of the window
   * @param height - the height ot the window
   */
  public void setWindowSize(WDCssSize width, WDCssSize height);

  /**
   * Method setWindowPosition - sets the absolute window position of the window in "px".
   * @param left - the horizontal position - default is 0 -> left side
   * @param top - the vertical position - default is 0 -> on the top
   */
  public void setWindowPosition(int left, int top);
  
  /**
   * Method setWindowPosition - sets the absolute window position of the window.
   * @param left - the horizontal position - default is 0 -> left side
   * @param top - the vertical position - default is 0 -> on the top
   */
  public void setWindowPosition(WDCssSize left, WDCssSize top);

  /**
   * Method setWindowPosition - sets a relative position of the window, e.g. centered, use constants of WDWindowPos to set the value
   * @param posType - default is absolute position
   */
  public void setWindowPosition(WDWindowPos position);

  /**
   * Method opens the window. In the current request/response-
   * cycle, no further manipulations are allowed 
   */
  public void open(); 
  
  /**
   * Method destroy: invalidates/destroys window instance - the instance is closed and destroyed and can not be reused/reopened
   */
  public void destroy();
  
  /**
   * Method removes a window feature in the window instance.
   * Removing a feature is valid until the window is opened, 
   * afterwards the window has to be closed for removing other features.
   * default is that all window features are added. 
   */
  public void removeWindowFeature(WDWindowFeature feature);

}
