/*
 * SAP Copyright (c) 2002
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/sal/url/api/WDWebResourceType.java#5 $
 */
package com.sap.tc.webdynpro.services.sal.url.api;

import com.sap.tc.webdynpro.services.sal.util.cache.ResourceType;

/**
 * Defines all needed constants for web resource types.
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public class WDWebResourceType extends ResourceType{


  /** Constant identifying a gif web resource type. */
  public static final WDWebResourceType GIF_IMAGE;

  /** Constant identifying a jpg web resource type. */
  public static final WDWebResourceType JPG_IMAGE;

  /** Constant identifying a vml web resource type. */
  public static final WDWebResourceType VML;

  /** Constant identifying a png web resource type. */
  public static final WDWebResourceType PNG;

  /** Constant identifying a svg web resource type. */
  public static final WDWebResourceType SVG;

  /** Constant identifying a Java script web resource type. */
  public static final WDWebResourceType JAVA_SCRIPT;

  /** Constant identifying an xml web resource type. */
  public static final WDWebResourceType XML;

  /** Constant identifying a css web resource type. */
  public static final WDWebResourceType CSS;

  /** Constant identifying a Java web resource type. */
  public static final WDWebResourceType JAVA;

  /** Constant identifying an applet web resource type. */
  public static final WDWebResourceType APPLET;

  /** Constant identifying a flash web resource type. */
  public static final WDWebResourceType FLASH;

  /** Constant identifying a pdf web resource type. */
  public static final WDWebResourceType PDF;

  /** Constant identifying an html web resource type. */
  public static final WDWebResourceType HTML;
  
  /** Constant identifying a Web Dynpro application. */
  public static final WDWebResourceType WD_APPLICATION; 

  /** Constant identifying a xml configuration file. */
  public static final WDWebResourceType XML_CONFIGURATION;

  /** Constant identifying a txt file. */
  public static final WDWebResourceType TXT;  

	/** Constant identifying unknown file. */
	public static final WDWebResourceType UNKNOWN;  

  /** Constant identifying powerpoints. */
  public static final WDWebResourceType PPT;

  /** Constant identifying rich text files. */
  public static final WDWebResourceType RTF;

  /** Constant identifying excel files. */
  public static final WDWebResourceType XLS;

  /** Constant identifying word files. */
  public static final WDWebResourceType DOC;

  /** Constant identifying post script files. */
  public static final WDWebResourceType PS;


  static{
    PS =  new WDWebResourceType("ps", "application/postscript", false, true);
    DOC =  new WDWebResourceType("doc", new String[]{"application/vnd.ms-word", 
                                                      "application/x-msword",
                                                      "application/ms-word"}, false, true);
    XLS =  new WDWebResourceType("xls", new String[]{"application/vnd.ms-excel", 
                                                      "application/x-msexcel",
                                                      "application/ms-excel"}, false, true);
    RTF =  new WDWebResourceType("rtf", "application/rtf", false, true);
    PPT =  new WDWebResourceType("ppt", new String[]{"application/vnd.ms-powerpoint", 
                                                    "application/x-mspowerpoint",
                                                    "application/ms-powerpoint"}, false, true);
    TXT = new WDWebResourceType("txt", "text/plain", false, true);
    GIF_IMAGE = new WDWebResourceType("gif", "image/gif", false, true);
    JPG_IMAGE = new WDWebResourceType("jpg", "image/jpeg", false, true);
    VML = new WDWebResourceType("vml", "text/vml", false, true);
    PNG = new WDWebResourceType("png", "image/x-png", false, true);
    SVG = new WDWebResourceType("svg", "image/svg+xml", false, true);
    JAVA_SCRIPT = new WDWebResourceType("js", "text/js", false, true);
    XML = new WDWebResourceType("xml", "text/xml", false, true);
    CSS = new WDWebResourceType("css", "text/css", false, true);
    JAVA = new WDWebResourceType("java", "application/x-java", false, true);
    APPLET = new WDWebResourceType("jar", "application/x-java", true, true);
    FLASH = new WDWebResourceType("swf", "application/x-shockwave-flash", false, true); 
    PDF = new WDWebResourceType("pdf", "application/pdf", false, true);
    HTML = new WDWebResourceType("html", "text/html", false, true);
    WD_APPLICATION = new WDWebResourceType( "", "", false, true); 
    XML_CONFIGURATION = new WDWebResourceType( "xml", "text/xml", true, true);
    UNKNOWN = new WDWebResourceType("", "", true, false); 
  }


  protected WDWebResourceType(String fileExtension, String htmlMime, boolean isAttachment, boolean addToContainer) {
    super(htmlMime, fileExtension, isAttachment, addToContainer);
  }

  protected WDWebResourceType(String fileExtension, String[] htmlMimes, boolean isAttachment, boolean addToContainer) {
    this(fileExtension, htmlMimes[0], isAttachment, addToContainer);
    if(addToContainer){
      for(int i = 1;i < htmlMimes.length;i++){ 
        new WDWebResourceType(fileExtension, htmlMimes[i], isAttachment, addToContainer);
        
      }
    }
  }


  /**
   * Constructor for WDWebWDWebResourceType.
   * @param fileExtension
   * @param htmlMime
   * @param isAttachment
   */
  public WDWebResourceType(String fileExtension, String htmlMime, boolean isAttachment) {
    this(fileExtension, htmlMime, isAttachment, false);
  }

  /**
   * Method getTypeForFileExtentsion: returns WDWebResourceType for given fileExtension, if
   * a defined WDWebResourceType matches to fileExtension, else returns null
   * @param fileExtension
   * @return returns WDWebResourceType for given fileExtension
   * @deprecated The name of this method contained a typo, use {@link #getWebResourceTypeForFileExtension(String)}
   *   instead. The method with the old name has been kept for backward compatibility reasons 
   *   only and may be withdrawn with the first new NetWeaver release in 2006.
   */
  public final static WDWebResourceType getWebResourceTypeForFileExtentsion(String fileExtension){
    return getWebResourceTypeForFileExtension(fileExtension);
  }

  
  /**
   * Method getTypeForFileExtension: returns WDWebResourceType for given fileExtension, if
   * a defined WDWebResourceType matches to fileExtension, else returns null
   * @param fileExtension
   * @return returns WDWebResourceType for given fileExtension
   */
  public final static WDWebResourceType getWebResourceTypeForFileExtension(String fileExtension){
    fileExtension = fileExtension.toLowerCase();
    WDWebResourceType type = (WDWebResourceType)WDWebResourceType.extensionResources.get(fileExtension);
    return type;
  }
  
  /**
   * Method getTypeForHtmlMime:  returns WDWebResourceType for given mimetype, if
   * a defined WDWebResourceType matches to mimetype, else returns null
   * @param htmlMime
   * @return WDWebResourceType for given mimetype
   */
  public final static WDWebResourceType getWebResourceTypeForHtmlMime(String htmlMime){
    WDWebResourceType type = (WDWebResourceType)WDWebResourceType.mimeResources.get(htmlMime);
    return type;
  }
  
  /**
   * Method getWebResourceType:  returns WDWebResourceType 
   * first searches WDWebResourceType for content stream (htmlMime) and then (if it was not found) searches for the fileExtension. 
   * If both were not successful, a new WDWebResourceType is created.
   * @param htmlMime
   * @return WDWebResourceType for given mimetype
   */
  public final static WDWebResourceType getWebResourceType(String htmlMime, String fileExtension){
    WDWebResourceType type = getWebResourceTypeForHtmlMime(htmlMime);
    if(type == null){
      type = getWebResourceTypeForFileExtension(fileExtension);
      if(type == null){
        type = new WDWebResourceType(fileExtension, htmlMime, true);
      }
    }
    return type;
  }

  /**
   * Method getTypeForFileExtentsion: returns ResourceType for given fileExtension, if
   * a defined ResourceType matches to fileExtension, else returns null
   * @param fileExtension
   * @return returns ResourceType for given fileExtension
   * @deprecated please use getWebResourceTypeForFileExtension
   * This method has been kept for backward compatibility reasons 
   * only and may be withdrawn with the first new NetWeaver release in 2006.
   */
  public static ResourceType getResourceTypeForFileExtentsion(String fileExtension) {
    return ResourceType.getResourceTypeForFileExtentsion(fileExtension);
  }

  /**
   * Method getTypeForHtmlMime:  returns WDWebResourceType for given mimetype, if
   * a defined WDWebResourceType matches to mimetype, else returns null
   * @param htmlMime
   * @return WDWebResourceType for given mimetype
   * @deprecated please use getWebResourceTypeForHtmlMime
   * This method has been kept for backward compatibility reasons 
   * only and may be withdrawn with the first new NetWeaver release in 2006.
   */
  public static ResourceType getResourceTypeForHtmlMime(String htmlMime) {
    return ResourceType.getResourceTypeForHtmlMime(htmlMime);
  }

  /**
   * Return is the MIME type associated to the web resource type. 
   * 
   * @return the mime type in x.400
   */
  public String getHtmlMime() {
    return htmlMime;
  }

  /**
   * Return is the file extension of the web resource type. 
   * 
   * @return the file extension of the web resource type
   */
  public String getFileExtension() {
    return fileExtension;
  }

  /**
   * Returns true if the web resource type is an HTTP attachement.
   * 
   * @return true if the type is used as file attachment
   */
  public boolean isAttachment() {
    return isAttachment;
  }
 }
