/*
 * SAP Copyright (c) 2002
 * All rights reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/sal/um/api/WDUMException.java#1 $
 */
package com.sap.tc.webdynpro.services.sal.um.api;

import com.sap.tc.webdynpro.services.exceptions.WDException;

/**
 * Thrown if something goes wrong in the Web Dynpro user management service.
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 */
public class WDUMException extends WDException {

  /**
   * Constructor for WDUMException.
   * @param messageText
   */
  public WDUMException(String messageText) {
    super(messageText);
  }

  /**
   * Constructor for WDUMException.
   * @param messageText
   * @param reason
   */
  public WDUMException(String messageText, Throwable reason) {
    super(messageText, reason);
  }

  /**
   * Constructor for WDUMException.
   * @param reason
   */
  public WDUMException(Throwable reason) {
    super(reason);
  }

  /**
   * Constructor for WDUMException.
   * @param messageText
   * @param parameters
   */
  public WDUMException(String messageText, Object[] parameters) {
    super(messageText, parameters);
  }

  /**
   * Constructor for WDUMException.
   * @param messageText
   * @param parameters
   * @param reason
   */
  public WDUMException(String messageText, Object[] parameters, Throwable reason) {
    super(messageText, parameters, reason);
  }
}
