/*
 * SAP Copyright (c) 2002
 * All rights reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/sal/sl/api/WDJCOClientConnectionStatus.java#1 $
 */
package com.sap.tc.webdynpro.services.sal.sl.api;

import com.sap.tc.webdynpro.services.exceptions.WDIllegalArgumentException;

/**
 * Class describing the different possible states of a JCO client connection.
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 * 
 */
public final class WDJCOClientConnectionStatus { 
  
  private static final String STATUS_OK_STRING = "statusOk";
  private static final String STATUS_NOT_DEFINED_STRING = "statusNotDefined";
  private static final String STATUS_INVALID_DEFINITION_STRING = "statusInvalidDefinition";
	private static final String STATUS_UNKNOWN_STRING = "statusUnknown";
      
  public static final WDJCOClientConnectionStatus STATUS_OK = new WDJCOClientConnectionStatus (STATUS_OK_STRING);
  public static final WDJCOClientConnectionStatus STATUS_NOT_DEFINED = new WDJCOClientConnectionStatus (STATUS_NOT_DEFINED_STRING);
  public static final WDJCOClientConnectionStatus STATUS_INVALID_DEFINITION = new WDJCOClientConnectionStatus (STATUS_INVALID_DEFINITION_STRING);
	public static final WDJCOClientConnectionStatus STATUS_UNKNOWN = new WDJCOClientConnectionStatus (STATUS_UNKNOWN_STRING);

  
  private String value = null;

  /**
   * Constructor for WDUserDefinitionType.
   */
  private WDJCOClientConnectionStatus(String value) {
    this.value = value;
  }

  public String toString () {
    return value;  
  }
  
  public static WDJCOClientConnectionStatus getStatus (String value) {
  
    if (value.equals(STATUS_OK_STRING)) {
      return STATUS_OK;  
    }
    else if (value.equals(STATUS_NOT_DEFINED_STRING)) {
      return STATUS_NOT_DEFINED;  
    }
    else if (value.equals(STATUS_INVALID_DEFINITION_STRING)) {
      return STATUS_INVALID_DEFINITION;  
    }
		else if (value.equals(STATUS_UNKNOWN_STRING)) {
					return STATUS_UNKNOWN;  
		}
    else {
      throw new WDIllegalArgumentException ("Invalid value string '" + value + "' to get JCO client connection");   
    }  
  }
}
