/*
 * SAP Copyright (c) 2002
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/sal/deployment/api/WDDeploymentException.java#1 $
 */
package com.sap.tc.webdynpro.services.sal.deployment.api;

import com.sap.tc.webdynpro.services.exceptions.WDException;

/**
 * This class is used for deployment exceptions like 
 * the logical name of an application that couldn't be resolved, 
 * etc. 
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public class WDDeploymentException extends WDException {

  /**
   * Constructs a DeploymentException object. 
   *
   * @param messageText message text of the exception
   */
  public WDDeploymentException(String messageText) {
    super(messageText);
  }

  /**
   * Constructs a DeploymentException object.
   *
   * @param messageText message text of the exception
   * @param reason the reason of the exception
   */
  public WDDeploymentException(String messageText, Throwable reason) {
    super(messageText, reason);
  }

  /**
   * Constructor for DeploymentException.
   * @param messageText
   * @param parameters
   */
  public WDDeploymentException(String messageText, Object[] parameters) {
    super(messageText, parameters);
  }

  /**
   * Constructor for DeploymentException.
   * @param messageText
   * @param parameters
   * @param reason
   */
  public WDDeploymentException(String messageText, Object[] parameters, Throwable reason) {
    super(messageText, parameters, reason);
  }

  /**
   * Constructs a DeploymentException object.
   *
   * @param reason the reason of the exception
   */
  public WDDeploymentException(Throwable reason) {
    super(reason);
  }

}
