/*
 * SAP Copyright (c) 2002
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/sal/deployment/api/WDAliasResolvingException.java#1 $
 */
package com.sap.tc.webdynpro.services.sal.deployment.api;

import com.sap.tc.webdynpro.services.exceptions.WDException;

/**
 * This exception is thrown, if an alias to another deployable object and application 
 * couldn't be resolved.  
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public class WDAliasResolvingException extends WDException {
  
  /**
   * Constructs a <code>WDAliasResolvingException</code> object.
   *
   * @param messageText message text of the exception
   */
  public WDAliasResolvingException(String messageText) {
    super(messageText);
  }

  /**
   * Constructs a <code>WDAliasResolvingException</code> object.
   *
   * @param messageText message text of the exception
   * @param reason the reason of the exception
   */
  public WDAliasResolvingException(String messageText, Throwable reason) {
    super(messageText, reason);
  }

  /**
   * Constructor for WDAliasResolvingException.
   * @param messageText
   * @param parameters
   */
  public WDAliasResolvingException(String messageText, Object[] parameters) {
    super(messageText, parameters);
  }

  /**
   * Constructor for WDAliasResolvingException.
   * @param messageText
   * @param parameters
   * @param reason
   */
  public WDAliasResolvingException(String messageText, Object[] parameters, Throwable reason) {
    super(messageText, parameters, reason);
  }

  /**
   * Constructs a <code>WDAliasResolvingException</code> object.
   *
   * @param reason the reason of the exception
   */
  public WDAliasResolvingException(Throwable reason) {
    super(reason);
  } 
  
  

}
