/*
 * SAP Copyright (c) 2002
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/sal/config/api/WDInvalidConfigParameterException.java#1 $
 */
package com.sap.tc.webdynpro.services.sal.config.api;

/**
 * This exception is thrown, if a configuration parameter 
 * could not be found in the configuration. 
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public class WDInvalidConfigParameterException extends WDConfigurationException {
  
  /**
   * Constructs a WDInvalidConfigParameterException object.
   *
   * @param messageText message text of the exception
   */
  public WDInvalidConfigParameterException(String messageText) {
    super(messageText);
  }
  
  /**
   * Constructs a WDInvalidConfigParameterException object.
   *
   * @param messageText message text of the exception
   * @param reason the reason of the exception
   */
  public WDInvalidConfigParameterException(String messageText, Throwable reason) {
    super(messageText, reason);
  }

  /**
   * @param messageText
   * @param parameters
   */
  public WDInvalidConfigParameterException(String messageText, Object[] parameters) {
    super(messageText, parameters);    
  }

  /**
   * @param messageText
   * @param parameters
   * @param reason
   */
  public WDInvalidConfigParameterException(String messageText, Object[] parameters, Throwable reason) {
    super(messageText, parameters, reason);
  }

  /**
   * Constructs a WDInvalidConfigParameterException object.
   *
   * @param reason the reason of the exception
   */
  public WDInvalidConfigParameterException(Throwable reason) {
    super(reason);
  }

}
