/*
 * SAP Copyright (c) 2002
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/sal/config/api/WDConfigurationNotFoundException.java#1 $
 */
package com.sap.tc.webdynpro.services.sal.config.api;

/**
 * This exception is thrown, if a specified configuration unit couldn't be 
 * loaded. 
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public class WDConfigurationNotFoundException extends WDConfigurationException {
  
  /**
   * Constructs a WDConfigurationNotFoundException object.
   *
   * @param messageText message text of the exception
   */
  public WDConfigurationNotFoundException(String messageText) {
    super(messageText);
  }

  /**
   * Constructs a WDConfigurationNotFoundException object.
   *
   * @param messageText message text of the exception
   * @param reason the reason of the exception
   */
  public WDConfigurationNotFoundException(String messageText, Throwable reason) {
    super(messageText, reason);
  }

  /**
   * Constructor for WDConfigurationNotFoundException.
   * @param messageText
   * @param parameters
   */
  public WDConfigurationNotFoundException(String messageText, Object[] parameters) {
    super(messageText, parameters);
  }

  /**
   * Constructor for WDConfigurationNotFoundException.
   * @param messageText
   * @param parameters
   * @param reason
   */
  public WDConfigurationNotFoundException(String messageText, Object[] parameters, Throwable reason) {
    super(messageText, parameters, reason);
  }

  /**
   * Constructs a WDConfigurationNotFoundException object.
   *
   * @param reason the reason of the exception
   */
  public WDConfigurationNotFoundException(Throwable reason) {
    super(reason);
  }
}
