/*
 * SAP Copyright (c) 2002
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/sal/config/api/WDConfigurationException.java#1 $
 */
package com.sap.tc.webdynpro.services.sal.config.api;

import com.sap.tc.webdynpro.services.exceptions.WDException;

/**
 * This is the base class for all Web Dynpro configuration exceptions, which
 * are thrown if something goes wrong when accessing/reading a Web Dynpro
 * configuration unit.
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public class WDConfigurationException extends WDException {

  /**
   * Constructs a WDConfigurationException object.
   *
   * @param messageText message text of the exception
   */
  public WDConfigurationException(String messageText) {
    super(messageText);
  }

  /**
   * Constructs a WDConfigurationException object.
   *
   * @param messageText message text of the exception
   * @param reason the reason of the exception
   */
  public WDConfigurationException(String messageText, Throwable reason) {
    super(messageText, reason);
  }

  /**
   * Constructor for WDConfigurationException.
   * @param messageText
   * @param parameters
   */
  public WDConfigurationException(String messageText, Object[] parameters) {
    super(messageText, parameters);
  }

  /**
   * Constructor for WDConfigurationException.
   * @param messageText
   * @param parameters
   * @param reason
   */
  public WDConfigurationException(String messageText, Object[] parameters, Throwable reason) {
    super(messageText, parameters, reason);
  }

  /**
   * Constructs a WDConfigurationException object.
   *
   * @param reason the reason of the exception
   */
  public WDConfigurationException(Throwable reason) {
    super(reason);
  } 
}
