/*
 * SAP Copyright (c) 2002
 * All rights reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/sal/adapter/api/WDWebContextAdapter.java#2 $
 */
package com.sap.tc.webdynpro.services.sal.adapter.api;

import com.sap.tc.webdynpro.services.task.TaskBinder;

/**
 * This class allows the access to the origin request. If Web Dynpro is used
 * within the SAP Portal Runtime, the Web Dynpro application developer may
 * use Portal services. For that, the origin request object is often needed to 
 * use a lot of the existing Portal services. In the Portal case, the origin 
 * request would be a <code>IPortalComponentRequest</code> object. 
 *
 * @see com.sap.tc.webdynpro.services.sal.adapter.api.IWDWebContextAdapterFactory
 * @see com.sap.tc.webdynpro.services.sal.adapter.api.IWDWebContextAdapter
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public abstract class WDWebContextAdapter {

  /**
   * @see com.sap.tc.webdynpro.services.sal.adapter.api.IWDWebContextAdapterFactory#getWebContextAdapter()
   */
  public static IWDWebContextAdapter getWebContextAdapter() {
    return TaskBinder.getCurrentTask().getWebContextAdapter();
  }

}
