/*
 * SAP Copyright (c) 2004
 * All rights reserved
 * 
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/sal/adapter/api/IWDWebContextAdapterFactory.java#1 $
 */
package com.sap.tc.webdynpro.services.sal.adapter.api;

/**
 * The interface defines the public API of the web context adapter factory. 
 * The factory is used to access <code>IWDWebContextAdapter</code> instances.
 *
 * @see com.sap.tc.webdynpro.services.sal.adapter.api.IWDWebContextAdapter
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDWebContextAdapterFactory {

  /**
   * WebContextAdapter abstracts from any protocol and plattform dependent contexts,
   * this method returns the adapter for the actual request
   * 
   * @return the adapter for the actual request
   */
  IWDWebContextAdapter getWebContextAdapter(); 
}

