/*
 * SAP Copyright (c) 2002
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/message/WDMessageType.java#1 $
 */
package com.sap.tc.webdynpro.services.message;

import java.util.*;

/**
 * Enumeration of client message types.
 * 
 * This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 */
public final class WDMessageType
{
  /**
   * Map from string representation to enumeration value.
   */
  private final static Map valueMap = new HashMap();

  /**
   * Error message.
   */
  public final static WDMessageType ERROR = new WDMessageType("error");
  /**
   * Informational message.
   */
  public final static WDMessageType STANDARD = new WDMessageType("standard");
  /**
   * Warning message.
   */
  public final static WDMessageType WARNING = new WDMessageType("warning");

  /**
   * Returns string representation of enumeration value.
   */
  public String toString()
  {
    return value;
  }

  /**
   * Returns the enumeration value for the given string representation. Ignores case.
   */
  public static WDMessageType valueOf(String s)
  {
    // ignore case of argument
    String lower = s.toLowerCase();
    if (valueMap.containsKey(lower))
    {
      return (WDMessageType)valueMap.get(lower);
    }
    throw new IllegalArgumentException("WDMessageType: Invalid enumeration value: " + s);
  }

  /**
   * Returns an iterator over the enumeration values.
   */
  public static Iterator iterateValues()
  {
    return valueMap.values().iterator();
  }

  /**
   * Private constructor to control instances.
   */
  private WDMessageType(String value)
  {
    this.value = value;
    valueMap.put(value, this);
  }

  /**
   * String representation of this enumeration value.
   */
  private String value;
}
