/*
 * SAP Copyright (c) 2002-2004
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/exceptions/WDTypeNotFoundException.java#2 $
 */
package com.sap.tc.webdynpro.services.exceptions;

/**
 * Thrown if a Java Dictionary Type is not found.
 * 
 * @deprecated This class might be withdrawn from the Web Dynpro API 
 *    with the first new NetWeaver release in 2006. It is not reasonable 
 *    for applications to explicitly catch this subclass of WDRuntimeException.
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 */
public class WDTypeNotFoundException extends WDRuntimeException {
  public WDTypeNotFoundException(String typename) {
    super("type {0} not found", new Object[]{typename});
    this.typename = typename;
  }

  public WDTypeNotFoundException(String typename, Exception e) {
    super("type {0} could not be loaded: {1}", new Object[]{typename, e}, e);
    this.typename = typename;
  }

  public WDTypeNotFoundException(String message, String typename) {
    super(message, new Object[]{typename});
    this.typename = typename;
  }

  public String getTypename() {
    return typename;
  }

  String typename;
}
