/*
 * SAP Copyright (c) 2002-2004
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/exceptions/WDRuntimeException.java#2 $
 */
package com.sap.tc.webdynpro.services.exceptions;

import com.sap.exception.BaseRuntimeException;

/**
 * Base class for all runtime exceptions thrown by the Web Dynpro API.
 * 
 * Applications using Web Dynpro can reference or catch this exception,
 * but THEY MUST NOT THROW OR EXTEND IT! </p>
 *  
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/exceptions/WDRuntimeException.java#2 $
 */
public class WDRuntimeException extends BaseRuntimeException
{
  /**
   * Creates a web dynpro exception
   */
  public WDRuntimeException(String messageText) {
    this(messageText, null, null);
  }

  /**
   * Creates a web dynpro exception
   */
  public WDRuntimeException(String messageText, Throwable reason) {
    this(messageText, null, reason);
  }

  /**
   * Creates a web dynpro exception
   */
  public WDRuntimeException(Throwable reason) {
    super(reason);
  }

  /**
   * Creates a web dynpro exception
   */
  public WDRuntimeException(String messageText, Object[] parameters) {
    this(messageText, parameters, null);
  }

  /**
   * Creates a web dynpro exception
   */
  public WDRuntimeException(String messageText, Object[] parameters, Throwable reason) {
    super(new WDException.DummyLocalizableTextFormatter(messageText, parameters), reason);
  }
}
