/*
 * SAP Copyright (c) 2002-2004
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/exceptions/WDException.java#2 $
 */
package com.sap.tc.webdynpro.services.exceptions;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.TimeZone;

import com.sap.exception.BaseException;
import com.sap.localization.LocalizableText;
import com.sap.localization.LocalizationException;

/**
 * Base class for all checked exceptions thrown by the Web Dynpro API. </p>
 * 
 * Applications using Web Dynpro can reference or catch this exception,
 * but THEY MUST NOT THROW OR EXTEND IT! </p>
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/exceptions/WDException.java#2 $
 */
public class WDException extends BaseException
{
  /**
   * Creates a web dynpro exception
   */
  public WDException(String messageText) {
    this(messageText, null, null);
  }

  /**
   * Creates a web dynpro exception
   */
  public WDException(String messageText, Throwable reason) {
    this(messageText, null, reason);
  }

  /**
   * Creates a web dynpro exception
   */
  public WDException(Throwable reason) {
    super(reason);
  }

  /**
   * Creates a web dynpro exception
   */
  public WDException(String messageText, Object[] parameters) {
    this(messageText, parameters, null);
  }

  /**
   * Creates a web dynpro exception
   */
  public WDException(String messageText, Object[] parameters, Throwable reason) {
    super(new DummyLocalizableTextFormatter(messageText, parameters), reason);
  }

  /**
   * Inner class for pretending localized texts, as long as there are none
   * @SAPWebDynproPart 4
   */
  static class DummyLocalizableTextFormatter implements LocalizableText {
    
    public DummyLocalizableTextFormatter(String messageText, Object[] parameters) {
      text = messageText == null ? null : MessageFormat.format(messageText, parameters);
    }
    
    /**
     * @see com.sap.localization.LocalizableText#finallyLocalize()
     */
    public void finallyLocalize() throws LocalizationException {
    }

    /**
     * @see com.sap.localization.LocalizableText#finallyLocalize(Locale, TimeZone)
     */
    public void finallyLocalize(Locale arg0, TimeZone arg1) throws LocalizationException {
    }

    /**
     * @see com.sap.localization.LocalizableText#finallyLocalize(Locale)
     */
    public void finallyLocalize(Locale arg0) throws LocalizationException {
    }

    /**
     * @see com.sap.localization.LocalizableText#finallyLocalize(TimeZone)
     */
    public void finallyLocalize(TimeZone arg0) throws LocalizationException {
    }

    /**
     * @see com.sap.localization.LocalizableText#format()
     */
    public String format() throws LocalizationException {
      return text;
    }

    /**
     * @see com.sap.localization.LocalizableText#format(Locale, TimeZone)
     */
    public String format(Locale arg0, TimeZone arg1) throws LocalizationException {
      return this.format();
    }

    /**
     * @see com.sap.localization.LocalizableText#format(Locale)
     */
    public String format(Locale arg0) throws LocalizationException {
      return this.format();
    }

    /**
     * @see com.sap.localization.LocalizableText#format(TimeZone)
     */
    public String format(TimeZone arg0) throws LocalizationException {
      return this.format();
    }

    /**
     * @see com.sap.localization.Localizable#getLocale()
     */
    public Locale getLocale() {
      return locale;
    }

    /**
     * @see com.sap.localization.Localizable#getTimeZone()
     */
    public TimeZone getTimeZone() {
      return timeZone;
    }

    /**
     * @see com.sap.localization.Localizable#setLocale(Locale)
     */
    public void setLocale(Locale arg0) {
      locale = arg0;
    }

    /**
     * @see com.sap.localization.Localizable#setTimeZone(TimeZone)
     */
    public void setTimeZone(TimeZone arg0) {
      timeZone = arg0;
    }

    private TimeZone timeZone;
    private Locale   locale;
    private final String text;
}
  
}
