/*
 * SAP Copyright (c) 2004
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/cal/api/WDResponseStatusCodeType.java#2 $
 */
package com.sap.tc.webdynpro.services.cal.api;

/**
 * Class ResponseStatusCodeType defines status codes for error pages in a platform
 * and protocol independent way.
 *  
 * @author SAP
 * @SAPWebDynproPart 2
 */
public class WDResponseStatusCodeType {
  /** status code for internal server error */
  public static final WDResponseStatusCodeType INTERNAL_APPLICATION_ERROR;
  /** status code for application locked */
  public static final WDResponseStatusCodeType APPLICATION_LOCKED;

  /** status code of the instance */
  private final int code;  

  static{
    //  !!numbers must be kept in sync with ResponseStatusCodeType!!
    INTERNAL_APPLICATION_ERROR = new WDResponseStatusCodeType(100);
    APPLICATION_LOCKED         = new WDResponseStatusCodeType(101);
  }
  
  /**
   * Constructor
   * @param code
   */
  protected WDResponseStatusCodeType(int code) {
    this.code = code;
  }    
  
  
  /* (non-Javadoc)
   * @see java.lang.Object#toString()
   */
  public String toString() {    
    return String.valueOf(code);
  }

}
