package com.sap.tc.webdynpro.services.api;

import com.sap.tc.webdynpro.services.exceptions.WDRuntimeException;

/**
 * This exception is thrown if - for any reason - no implementation class could
 * be created for an API interface.
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/api/WDHelperNotFoundException.java#1 $
 */
public class WDHelperNotFoundException extends WDRuntimeException {

  public WDHelperNotFoundException(Class aClass) {
    super("No implementation class found for {0} in the properties", 
           new Object[]{aClass});
  }

  public WDHelperNotFoundException(Throwable reason) {
    super(reason);
  }
}
