/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_modelimpl/java/com/sap/tc/webdynpro/modelimpl/rfcadapter/WDRFCException.java#1 $
 */
package com.sap.tc.webdynpro.modelimpl.rfcadapter;

import com.sap.tc.webdynpro.progmodel.model.api.WDModelException;

/**
 * Base class for exceptions that are thrown by the RFC Adapter implementation
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_modelimpl/java/com/sap/tc/webdynpro/modelimpl/rfcadapter/WDRFCException.java#1 $
 */
public class WDRFCException extends WDModelException
{

  public static final String RFCADAPTERCLASS_LIST_WRONG_ELEMENT_TYPE = "List must contain AbstractList (ProxyList) of Type '{0}', not of '{1}'!";
  /**
   * Creates a Web Dynpro RFC exception
   */
  public WDRFCException(String messageText) {
    this(messageText, null, null);
  }

  /**
   * Creates a Web Dynpro RFC exception
   */
  public WDRFCException(String messageText, Throwable reason) {
    this(messageText, null, reason);
  }

  /**
   * Creates a Web Dynpro RFC exception
   */
  public WDRFCException(Throwable reason) {
    this(null, null, reason);
  }

  /**
   * Creates a Web Dynpro RFC exception
   */
  public WDRFCException(String messageText, Object[] parameters) {
    this(messageText, parameters, null);
  }

  /**
   * Creates a Web Dynpro RFC exception
   */
  public WDRFCException(String messageText, Object[] parameters, Throwable reason)
  {
    super(messageText, parameters, reason);
  }

}
