#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/b_07/sys/src/install/perl/SAPDB/Install/Values.pm#1 $
# $DateTime: 2003/11/20 17:48:59 $
# $Change: 57359 $
#
# Desc: 

package SAPDB::Install::Values;

$VERSION = 1.01;


sub BEGIN {
    my $repo = SAPDB::Install::Repository::GetCurrent ();
	@ISA = ('SAPDB::Install::Exporter');
     @EXPORT = ('$owner','$uid', '$group', '$gid', '$node', '$chmod_nrm',
		 '$chmod_exe', '$chmod_suid', '$curDir', '$diemsg', '$ini_path','$product','$caption');     
	  foreach my $package ('Cwd'){
		unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
            	print join ("\n", $repo->GetErr)."\n";
            	die;
      	}
	} 
 }
		

#print "initialize variables\n";
$owner="";
$uid=0;
$group="";
$gid=0; 
$node="";
$log;
$indep_prog_path;
$indep_data_path;
$liveCachePath;
$APO_release;


$interface_version=0.1; # installer interface version
$chmod_nrm=0444;
$chmod_exe=0555;
$chmod_suid=06551;

$diemsg="installation exited abnormally ";

$product='MaxDB Software';

$ini_path = '/usr/spool/sql/ini/SAP_DBTech.ini';

$glob_path = '/etc/opt/sdb';

$TraceFileName = 'maxdb_installer_trace';


$curDir;

local $log; # log object
if(-d $SAPDB::Install::Config{'CallerDir'}){
	$curDir = $SAPDB::Install::Config{'CallerDir'};
	$curDir=~s/\\/\//g;
}
else{
	$curDir =SAPDB::Install::Cwd::getcwd();
	$curDir=~s/\\/\//g;
}

%package_interface=(
	'INTERFACE_VERSION' => undef,	# interface for installer "SDBINST" , if not match -> invalid package 
	'PACKAGE_NAME' => undef,		# name of package, (Server, Independent, Webtools,...) >>>unique package type identifier<<<
	'DISPLAY_NAME' => undef,		# name of package visible from outside
	'PACKAGE_VERSION' => undef,		# package release - important if there are more than one package with same software (maybe with few different files)
	'SOFTWARE_VERSION' => undef,	# real software release in this format MAJ.MIN.COR.PAT (7.3.0.15)
	'MIN_VERSION' => undef,			# software version an installed package must have to be updated with this one
	'TEST_FILE' => undef,			# executable used to check build number and what string
	'MAGIC_MODE' => undef,			# mode to test what string: 32TO64 | 64TO32 | EQUAL | NOBIT
	'MODE' => undef,				# object mode: 32 | 64
	'ALLOW_SKIP' => undef,			# allow installer to skip package in update case if magic or version dont match -> if not set - abort installation process in such case
	'TYPE' => undef,				# kind of package, only PATCH | FULL possible
	'DEFAULT_USER' => undef,		# 
	'DEFAULT_GROUP' => undef,		#
	'PART_OF' => undef,				# installation profile (Server,Client,SDK, ... )
	'IS_TOP_OF' => undef,			# installation profile (package "Database Kernel" is top of profile "Server")
	'REQUIRE' => undef,				# dependencies to other packages 
	'SCRIPT' => undef,				# name of install script
	'FILELIST' => undef,			# name of filelist
	'ARCHIVE_NAME' => undef,		# name of tgz archive, dont need it in signature file
	'IS_SUBPACKAGE' => undef,		# boolean value - is subpackage of first member of "REQUIRE" list  
	'SUB_DIR' => undef				# string value which defines part of package path which differs from parent package path 
);

1;