#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/b_07/sys/src/install/perl/SAPDB/Install/Uninstall/Collector.pm#1 $
# $DateTime: 2003/11/20 17:48:59 $
# $Change: 57359 $
#
# Desc: collect packages from install registry to delete, resolve dependencies  


package SAPDB::Install::Uninstall::Collector;

$VERSION = 1.01;

sub BEGIN {
    my $repo = SAPDB::Install::Repository::GetCurrent ();
	@EXPORT=('collect');
	my @neededPackages=(
		'System',
		'Registry',
		'Collector',
		'StdIO',
		'InstallRegistry',
		'Version',
		'Values',
		'MD5Sum',
		'SetDebug',
		'Log',
		'Tools',
		'Cwd',
		'Getopt::Long',
		'Misc',
		'Cleaner',
		'Trace'
	);
	foreach my $package (@neededPackages){
	  	unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                print join ("\n", $repo->GetErr)."\n";
                die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package"); 
	}
}

$DEBUG=0;


local %dispNameTable;


sub parseDep{
	my ($text)=@_;
	my $op = $text;
	my $version = $text;
	my $bit = $text;
	$op=~s/[^<>=]//g;   	
	$version =~ s/^.*$op\s*//g;     # remove operand
 	$version =~ s/\s+\d{2}\s*$//g;  # remove bit decimals (32|64) at the end
 	$version =~ /^\s*$/ and not $op =~ /^\s*$/ and print2stderr("dependency parse error\n") and diesoft($diemsg);
	$bit =~ s/^\s*$op$\s*version\s*//g; # remove operand and version
	$bit =~ s/\s*$//g;					# remove whitespaces at end of line
	$bit =~ /^\s*$/ and $bit = undef;
	not $version =~ /^\s*$/ and $op =~ /^\s*$/ and print2stderr("dependency parse error\n") and diesoft($diemsg);
	my %returnhash;
	$returnhash{'op'} = $op;
	$returnhash{'ver'} = $version;
	$returnhash{'bit'} = $bit;
	return %returnhash; 
}


my %node = (
	'display_name' => undef, # scalar
	'package_name' => undef, # scalar
	'package_path' => undef, # scalar
	'children' => undef # array of %nodes
); 

sub generateTree{
	my ($refData,%root_node) = @_;
	my %RegistryData=%$refData;	
		
	my @children = ();	

	unless(defined $root_node{'package_name'}){
		if(exists $dispNameTable{$root_node{'display_name'}}){
			$root_node{'package_name'} = $dispNameTable{$root_node{'display_name'}};
		}
		else{
			if(exists $RegistryData{$root_node{'display_name'}}){
				$root_node{'package_name'} = $root_node{'display_name'};
				$root_node{'display_name'} = ${%{${%{$RegistryData{$root_node{'package_name'}}}}{$root_node{'package_path'}}}}{'DispName'}
							if exists ${%{${%{$RegistryData{$root_node{'package_name'}}}}{$root_node{'package_path'}}}}{'DispName'};
			
			}
			else{						
				print2stderr("package \"".$root_node{'display_name'}."\" does not exist\n");
				return undef;		
			}
		}
 	}

	unless(exists ${%{$RegistryData{$root_node{'package_name'}}}}{$root_node{'package_path'}}){
		print2stderr("package $root_node{package_name} in $root_node{package_path} does not exist\n");
		return undef;
	}
				
	
	my %root_data = %{${%{$RegistryData{$root_node{'package_name'}}}}{$root_node{'package_path'}}};
	
	
	unless($root_node{'display_name'} =~ /\S/){
		if($root_data{'DispName'} =~ /\S/){
			$root_node{'display_name'} = $root_data{'DispName'};
		}
		else{
			$root_node{'display_name'} = $root_node{'package_name'};
		}	
	}


	foreach my $packname (keys(%RegistryData)){
		foreach my $packdir (keys(%{$RegistryData{$packname}})){
			my %packdata = %{${%{$RegistryData{$packname}}}{$packdir}};
			if($packdata{'IsSubPackage'}){
				my ($parent_name,$parent_path) = @{$packdata{'ParentPackage'}}; 
				if($parent_name eq $root_node{'package_name'} and $parent_path eq $root_node{'package_path'}){
				   push @children , generateTree($refData,('package_name' => $packname, 'package_path' => $packdir,
															'display_name' => defined $packdata{'DispName'} ? $packdata{'DispName'} : $packname));
				}
			}
			foreach my $req_strg  (@{$packdata{'Require'}}){
				$packdata{'IsSubPackage'} and ${@{$packdata{'Require'}}}[0] eq $req_strg and next; # first is checked by parent package member
				my ($req) = SAPDB::Install::Collector::parseRequire($req_strg);
				my %req = %$req;
				if ($req{'name'} eq $root_node{'package_name'}){
	 				if(checkRequired('package_name' => $root_node{'package_name'},
								'mode' => $root_data{'Mode'},
								'version' => $root_data{'Version'},
								'required' => $req)){
						push @children , generateTree($refData,('package_name' => $packname, 'package_path' => $packdir,
																'display_name' => defined $packdata{'DispName'} ? $packdata{'DispName'} : $packname));
					}	
				}
			}
			
		}
	}	
	
	my %tree = %root_node;
	unless($#children == -1){
		$tree{'children'} = \@children;
	}
	return \%tree; 
}


sub PackagesWithoutValidDeps{
	my ($refData) = @_;
	my @depless =  ();
	my %RegistryData=%$refData;	
	foreach my $packname (keys(%RegistryData)){
		$packname eq 'Base' and next;
		foreach my $packdir (keys(%{$RegistryData{$packname}})){
			my %packdata = %{${%{$RegistryData{$packname}}}{$packdir}};
			unless(exists $packdata{'Require'} and ref($packdata{'Require'}) eq 'ARRAY' and $#{@{$packdata{'Require'}}} > -1){
				push @depless,[$packname,$packdir];
				next;
			}
			if(exists $packdata{'IsSubPackage'} and $packdata{'IsSubPackage'}){
				my ($parent_name,$parent_path) = @{$packdata{'ParentPackage'}};
				unless(defined $parent_name and defined $parent_path){
					push @depless,[$packname,$packdir];
					next;
				} 
				unless(exists ${%{$RegistryData{$parent_name}}}{$parent_path}){
					push @depless,[$packname,$packdir];
					next;	
				}
			}
			my $dependency_found = 0;
			foreach my $req_strg (@{$packdata{'Require'}}){
				my ($req) = SAPDB::Install::Collector::parseRequire($req_strg);
				my %req = %$req;
				foreach my $inner_packdir (keys(%{$RegistryData{$req{'name'}}})){
					my $inner_packdata = %{${%{$RegistryData{$req{'name'}}}}{$inner_packdir}};
					if(checkRequired('package_name' => $req{'name'},
								'mode' => $inner_packdata{'Mode'},
								'version' => $inner_packdata{'Version'},
								'required' => $req)){
					
						$dependency_found = 1;
						last;
					}
				}
			}
			unless($dependency_found){
					push @depless,[$packname,$packdir];
					next;
			}	
			
		}
	}
	return @depless;
}


sub getPackagePath{
	my ($refData,$package_name) = @_;
	my %RegistryData=%$refData;	
	unless(exists $RegistryData{$package_name}){
		exists $dispNameTable{$package_name} or print2stderr("no package \"$package_name\" found\n") and return undef;
		$package_name = $dispNameTable{$package_name};
	}
	my @pathes = keys(%{$RegistryData{$package_name}});
	$#pathes == 0 and return $pathes[0];	  	
	my @table = ();
	foreach my $path (@pathes){
		my %packdata = %{${%{$RegistryData{$package_name}}}{$path}};
		push @table, [defined $packdata{'DispName'} ? $packdata{'DispName'} : $package_name,'in',$path,$packdata{'Version'},$packdata{'Mode'} =~ /\d/ ? $packdata{'Mode'}.' bit' : ''];
	}
	my $selection = ask4any(\@table,'package','uninstall');
	$selection == -1 and return undef;
	return $pathes[$selection];
}


sub generateList{
	my ($hrTree) = @_;
	my @list = ();
	foreach my $child (@{${%$hrTree}{'children'}}){
		push @list , generateList($child);
	}	 
	push @list, [${%$hrTree}{'package_name'},${%$hrTree}{'package_path'},${%$hrTree}{'display_name'}];
	return @list;
}



sub collect{
	my (%ARGS) = @_;
	my @returnvalue = ();
	my @package_list = ();
	local *instRegistry = $ARGS{'instreg'};
	defined $instRegistry or print2stderr("InstallRegistry not defined\n") and diesoft($diemsg);
	my $refData = $instRegistry->RegData;
	my %RegistryData=%{${%$refData}{'HashRef_Packages'}};	
	
	if(exists $ARGS{'collect_all'}){
		$ARGS{'package_name'} = 'Base';	
		$ARGS{'auto_resolve'} = 1;	
	}
	 		
	
	%dispNameTable = $instRegistry->getDisplayNameTable();
	
	unless(defined $ARGS{'package_path'} and $ARGS{'package_path'} =~ /\S/){
		$ARGS{'package_path'} = getPackagePath(\%RegistryData,$ARGS{'package_name'} =~ /\S/ ? $ARGS{'package_name'} : $ARGS{'display_name'});
		unless(defined $ARGS{'package_path'} and $ARGS{'package_path'} =~ /\S/){
			print2stdout("no package selected\n");
			diesoft('abort uninstall');
		}
	}	
	
	my $depTree = generateTree (\%RegistryData,('display_name' => $ARGS{'display_name'},'package_name' => $ARGS{'package_name'} , 'package_path' => $ARGS{'package_path'}));
	
	defined $depTree or return undef;
	if (exists ${%$depTree}{'children'} and not $ARGS{'auto_resolve'}){
		my @table = ();
		foreach my $child (@{${%$depTree}{'children'}}){
			push @table, [${%$child}{'display_name'},'in',${%$child}{'package_path'}];
		}
		print2stdout("\n\n");
		print2stdout("cannot uninstall package $ARGS{package_name} in $ARGS{package_path}: following packages are dependent:\n\n");
		printTable(\@table,' ' x 2);

		print2stdout("\n\n");
		diesoft($diemsg);
	}
	

	push @package_list, generateList($depTree); 
	
	
	if($ARGS{'package_name'} eq 'Base'){
		my @withoutdeps = PackagesWithoutValidDeps(\%RegistryData);
		foreach my $depless (@withoutdeps){
			my $depTree = generateTree(\%RegistryData,('package_name' => ${@$depless}[0],'package_path' => ${@$depless}[1]));
			unshift @package_list, generateList($depTree);
		}

	}
	
	
	
	#
	# remove doubles caused by unclearness of dependencies
	#

	my @new_list = ();
	foreach my $pack (@package_list){
		my $found = 0;
		foreach my $new_pack (@new_list){
			if(${@$new_pack}[0] eq ${@$pack}[0] and ${@$new_pack}[1] eq ${@$pack}[1]){
				$found = 1;
				last;
			}
		}
		unless($found){
			push @new_list,$pack;
		}	
	}	
	
	@package_list = @new_list;

	print2stdout("\nuninstall following package(s):\n\n");

	my @table = ();
	foreach my $pack (@package_list){
		my %packdata = %{${%{$RegistryData{${@$pack}[0]}}}{${@$pack}[1]}};
		push @table , [${@$pack}[2],${@$pack}[1], $packdata{'Version'}, $packdata{'Mode'} =~ /\S/ ? $packdata{'Mode'}.' bit' : ''];
	}	

	printTable(\@table,' ' x 2);

	print2stdout("\n\n");
	while(1){
		last if($SAPDB::Install::Config{'SilentMode'});
		print2stdout("start uninstallation now (y/n)?");
		$_=readstdin();
		last if /^y|^n/i; 
	}
	/^n/i && diesoft('abort uninstall');	

	
	#generate package objects

	foreach my $pack (@package_list){
		push @returnvalue , $instRegistry->getPackage(${@$pack}[0],${@$pack}[1]);
	}

	return @returnvalue;
}


1;