#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/b_07/sys/src/install/perl/SAPDB/Install/Trace.pm#1 $
# $DateTime: 2003/11/20 17:48:59 $ 
# $Change: 57359 $
#
# Desc: writes a trace if activated


package SAPDB::Install::Trace;

$VERSION = 1.01;

sub BEGIN {
      @ISA = ('SAPDB::Install::Exporter');
      @EXPORT = ('TraceLevel',
			'TraceMsg',
			'WriteTrace'
	);

	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages=(
		'Values',
		'StdIO',
		'Registry'
	);
	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                print join ("\n", $repo->GetErr)."\n";
                die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	  } 
}



my @msgbuff;
my $level = 0; # 0 - 5, 0 is default


# 0 -> no trace
# 1 -> STDOUT, STDERR, STDIN
# 2 -> LOG
# 3 -> medium trace output (main flow decisions)
# 4 -> more trace (creation / destruction of objects, minor flow decisions)
# 5 -> lot of details (values)

sub TraceLevel{
	my ($lvl) = @_;
	$level = $lvl;
};

sub TraceMsg{
	my ($msg,$lvl,$debug,$caller_level) = @_;
	$level == 0 && !$$debug && return 1;
	$caller_level =~ /^\d+$/ or $caller_level = 1; 
	my ($package, $filename, $line, $subroutine,$hasargs, $wantarray, $evaltext, $is_require) = caller ($caller_level);
	my $fmt_msg = $subroutine."(): $msg";
	$$debug && print "DEBUG: $fmt_msg";
	$fmt_msg = "$lvl: $fmt_msg";
	$fmt_msg =~ s/\n/\n$lvl: => /gs;
	$fmt_msg =~ s/$lvl:\s=>\s$//s;
	$level < $lvl || push @msgbuff , $fmt_msg;
	return 1; 
}

sub WriteTrace{
	my ($force) = @_;
	$force || $level > 0 || return;
	$#msgbuff == -1 and print2stdout ("no trace in buffer\n") and return 1;  
	my $filename = $SAPDB::Install::Values::TraceFileName;
	my ($data,$prog) = readIndepPath();
	my $path = "$data/wrk";
	-d $path or $path = $SAPDB::Install::Values::curDir;
	open (TRACE, ">$path/$filename") || print2stderr ("cannot create trace file \"$path/$filename\"\n");
	foreach my $line (@msgbuff){
		print TRACE $line;
	}
	close (TRACE);
	return 1;
}

1;