#!/usr/bin/perl
#
# $Header: //sapdb/V74/develop/sys/src/install/perl/SAPDB/Install/WIN32API/System.pm#2 $
# $DateTime: 2002/11/29 13:54:20 $
# $Change: 31986 $
#
# Desc: 


package SAPDB::Install::System::Win32::API;

sub import {
	local $SAPDB::Install::Exporter::ExportLevel = 1;
	SAPDB::Install::Exporter::import (@_);
	bootstrap SAPDB::Install::System::Win32::API;
}

sub BEGIN {
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages=(
		'Exporter'
	);
	foreach my $package (@neededPackages){
	  	unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                print join ("\n", $repo->GetErr)."\n";
                die;
        	}
		import ("SAPDB::Install::$package"); 
	}
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = (
		'System'
	);
}


sub AUTOLOAD {
	die unless ($AUTOLOAD =~ "bootstrap");
	require DynaLoader;
	push @ISA, 'DynaLoader';
	bootstrap SAPDB::Install::System::Win32::API;
}

1;