#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/b_07/sys/src/install/perl/SAPDB/Install/System/Unix/Dir.pm#1 $
# $DateTime: 2003/11/20 17:48:59 $
# $Change: 57359 $
#
# Desc: 

package SAPDB::Install::System::Unix::Dir;

sub import {
	local $SAPDB::Install::Exporter::ExportLevel = 1;
	SAPDB::Install::Exporter::import (@_);
	bootstrap SAPDB::Install::System::Unix::Directories;
}

sub BEGIN {
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Exporter'
	);

	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                print join ("\n", $repo->GetErr)."\n";
                die;
		}
		import ("SAPDB::Install::$package"); 
	}

	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ();
}

sub AUTOLOAD {
	die unless ($AUTOLOAD =~ "bootstrap");
	require DynaLoader;
	push @ISA, 'DynaLoader';
	bootstrap SAPDB::Install::System::Unix::Directories;
}

1;
