#!/usr/bin/perl
#
# $Header: //sapdb/V74/develop/sys/src/install/perl/SAPDB/Install/System/Unix.pm#2 $
# $DateTime: 2002/11/29 13:54:20 $
# $Change: 31986 $
#
# Desc: 


package SAPDB::Install::System::Unix;

sub import {
	local $SAPDB::Install::Exporter::ExportLevel = 1;
	SAPDB::Install::Exporter::import (@_);
	bootstrap SAPDB::Install::System::Unix;
}

sub BEGIN {
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Exporter'
	);

	foreach my $package (@neededPackages){
		unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
			print join ("\n", $repo->GetErr)."\n";
			die;
		}

		import ("SAPDB::Install::$package"); 
	}

	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = (
		'lchown', 'uaccess', 'ugetids', 'sprintmode'
	);
}

sub AUTOLOAD {
	print "unknown sub $AUTOLOAD called\n";
	die unless ($AUTOLOAD =~ "bootstrap");
	require DynaLoader;
	push @ISA, 'DynaLoader';
	bootstrap SAPDB::Install::System::Unix;
}

1;
