#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/b_07/sys/src/install/perl/SAPDB/Install/System.pm#1 $
# $DateTime: 2003/11/20 17:48:59 $
# $Change: 57359 $
#
# Desc: 


package SAPDB::Install::System;

$VERSION = 1.01;


$DEBUG = 0;

sub BEGIN {
      @ISA = ('SAPDB::Install::Exporter');
      @EXPORT = ('callsystem','copy', 'find','normalizePath', 'makedir','getuid','getgid',
		'checkrpm','changeOwner', 'evalScriptInTGZ', 'checkFileInTGZ', 'getSysTmpPath',
		 'checkServices','getSysProgPath','copyAscii','removeEmptyDirs','access','setPathInEnv',
		 'instWinSysFiles','getSysPath','getAppDataPath','genAbsPath','resolveLinks','unbusy');

	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages=(
		'StdIO',
		'Cwd',
		'Log',
		'Untgz',
		'Values',
		'Registry',
		'PipeExec',
		'Trace',
		'BuildInfo',
		'Tools',
		'Uninstall::RemoveFilesInUse'
	);
	
	push @neededPackages,'System::Win32::API' if $^O =~ /mswin/i;
	
	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                print join ("\n", $repo->GetErr)."\n";
                die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	  } 
}



sub removeEmptyDirs{
	my ($dir)=@_;
	my @not_removed;
	my @removed;
	-d $dir || $SAPDB::Install::Values::log->SetMsg("cannot remove directory\"$dir\": no such directory\n") && return 0;
	opendir(DH,$dir) or $SAPDB::Install::Values::log->SetMsg("cannot open directory \"$dir\"\n") and return (0,[],[$dir]);
	my @content=readdir(DH) or $SAPDB::Install::Values::log->SetMsg("cannot read directory \"$dir\"\n") and return (0,[],[$dir]);
	closedir(DH);
	if($#content == 1){
		#directory empty
		rmdir($dir) or $SAPDB::Install::Values::log->SetMsg("cannot remove directory \"$dir\": $!\n") and return (0,\@removed,[$dir]);
		push @removed,$dir;
		$SAPDB::Install::Values::log->SetMsg("directory \"$dir\" removed\n");
		return (1,\@removed,\@not_removed);
	}
	foreach my $element (@content){
		if(($element ne '.') and ($element ne '..')){
			if(-d "$dir/$element"){
				my ($rc,$ref_removed,$ref_unremoved) = removeEmptyDirs("$dir/$element"); 
				defined $ref_unremoved and push @not_removed,@$ref_unremoved;
				defined $ref_removed and push @removed,@$ref_removed;
			}
		}		
	}
	opendir(DH,$dir) or $SAPDB::Install::Values::log->SetMsg("cannot open directory \"$dir\"\n") and return (0,\@removed,[$dir]);
	my @content=readdir(DH) or $SAPDB::Install::Values::log->SetMsg("cannot read directory \"$dir\"\n") and return (0,\@removed,[$dir]);
	closedir(DH);
	if($#content == 1){
		#directory empty
		rmdir($dir) or $SAPDB::Install::Values::log->SetMsg("cannot remove directory \"$dir\": $!\n") and push @not_removed,$dir and return (0,\@removed,\@not_removed);
		$SAPDB::Install::Values::log->SetMsg("directory \"$dir\" removed\n");
		push @removed,$dir;
	}
	else{
		$SAPDB::Install::Values::log->SetMsg("cannot remove directory \"$dir\": directory is not empty\n");
		push @not_removed,$dir;	
		return (0,\@removed,\@not_removed);
	}
	return (1,\@removed,\@not_removed);
}	



sub callsystem{
    my $commandline=(@_)[0];
	local *checkfunc=$_[1]; # function reference to test stdout of system call
    my $dontdie=$_[2];
	my $outtext;
	my $pipehandle=SAPDB::Install::PipeExec::new();
	$pipehandle->Open($commandline);
	if($pipehandle->GetError){
                if($dontdie){
					$SAPDB::Install::Values::log->SetMsg("WRN: cannot execute command: ".$pipehandle->GetError."\n");
					return;
				}
				else{	
					print2stderr("cannot execute command: ".$pipehandle->GetError."\n");
					diesoft($SAPDB::Install::Values::diemsg);
				}
	}
	my $text;
	do{
		$text = $pipehandle->Readline();
		if(defined $text){
			$outtext.=$text;
			$SAPDB::Install::Values::log->SetMsg("SYS: $commandline: $text"."\n");
		}
	}until(not defined $text);
	
	unless(defined $outtext){
		$SAPDB::Install::Values::log->SetMsg("SYS: $commandline\n");	
	}
	
	if($_[1]){
		unless(checkfunc($outtext)){
			# checkfunction detected an error
			if($dontdie){
					$SAPDB::Install::Values::log->SetMsg("WRN: error occuered while executing command \"$commandline\" - said outtext parser\n");
					$SAPDB::Install::Values::log->SetMsg(join("\nSYS: $commandline: ",split("\n",$outtext))."\n");	
					return undef;
			}
			else{
				print2stderr("error occured while executing $commandline\n");
				print2stderr("$commandline: ".join("\n$commandline: ",split("\n",$outtext))."\n");
				diesoft($SAPDB::Install::Values::diemsg);
			}	
		}
	}
	else{
		if($pipehandle->GetError){
			if($dontdie){
					$SAPDB::Install::Values::log->SetMsg("WRN: error occuered while executing command \"$commandline\": ".$pipehandle->GetError."\n");
					$SAPDB::Install::Values::log->SetMsg(join("\nSYS: $commandline: ",split("\n",$outtext))."\n");	
					return;
			}
			else{
				print2stderr("error occuered while executing command \"$commandline\": ".$pipehandle->GetError."\n");
				print2stderr(join("\n$commandline: ",split("\n",$outtext))."\n");
				diesoft($SAPDB::Install::Values::diemsg);	
			}
		}
	}
	
	my $rc = $pipehandle->Close();
	return $rc;
}


sub copy{
	my ($src,$dst,$config)=@_;
	$src=~s/\\/\//g;
	$dst=~s/\\/\//g;
	-f $src or print2stderr("ERR: System::copy(): file \"$src\" not found\n") and return undef;
	my @statbuf = stat($src);
	open(SRC,$src) or print2stderr("ERR: System::copy(): cannot open file \"$src\": $!\n") and return undef;
	$config->{'binmode'} && binmode(SRC);
	my $dst_name;
	if(-d $dst){
		$src=~/([^\/]*)$/ and my $file=$1;
		open(DST,">$dst/$file") or print2stderr("ERR: System::copy(): cannot create $dst/$file: $!\n") and return undef;
		$dst_name = "$dst/$file";
	}
	elsif(-f $dst){
		open(DST,">$dst") or print2stderr("ERR: System::copy(): cannot create $dst\n") and return undef;
		$dst_name = $dst;
	}
	else{
		my $dir = $dst;
		$dir=~s/[^\/]*$//;
		$dst_name = $dst;
		unless(-d $dir){
			if($config->{'createdir'}){
				my $perm = 0775; #default
				$perm = $config->{'dir_perm'} if defined $config->{'dir_perm'}; 
				makedir($dir,$perm) or print2stderr("ERR: System::copy(): cannot create directory $dir: $!\n") and return undef;
			}
			else{
				print2stderr("ERR: System::copy(): cannot create $dst - parent dir missing\n") and return undef;
			}
		}  
		open(DST,">$dst") or print2stderr("ERR: System::copy(): cannot create $dst: $!\n") and return undef;
	}
	$config->{'binmode'} && binmode(DST);
	my $bufSize=(stat SRC)[11] || 32768;
	while(my $len = sysread(SRC,$buf,$bufSize)){
		unless(defined $len){
			next if $! =~ /^Interrupted/;
			print2stderr("ERR: System::copy(): read failure: $!\n") and return undef;
			return 0;
		} 
		my $offset=0;
		while($len){
			$written=syswrite(DST,$buf,$len,$offset);
			defined $written or print2stderr("ERR: System::copy(): write failure: $!\n") and return undef;
			$len-=$written;
			$offset+=$written;
		}	
	}
	close(SRC);
	close(DST);
	
	utime ($statbuf[8],$statbuf[9],$dst_name) or print2stderr("cannot set time of copied file \"$dst_name\": $!\n") and return undef;

	unless($^O =~ /mswin/i){
		$statbuf[2] &= 06777;
		if(not $config->{'nochown'} and $< != 0 and $< != $statbuf[4]){
				unless (($statbuf[2] & 06000) == 0){
					print2stderr("WRN: System::copy(): cannot set sbits of $dst_name\n");
					$statbuf[2] &= 0777;
				}
				chmod($statbuf[2],$dst_name) or print2stderr("cannot set mode of copied file \"$dst_name\": $!\n") and return undef;
		}
		unless($config->{'nochown'}){
			chown($statbuf[4],$statbuf[5],$dst_name) or print2stderr("cannot set uid/gid of copied file \"$dst_name\": $!\n") and return undef; 
		}
		unless(($statbuf[2] & 06000) == 0 ){
			chmod($statbuf[2],$dst_name) or print2stderr("cannot set mode of copied file \"$dst_name\": $!\n") and return undef;
		}
	}
	defined $SAPDB::Install::Values::log and $SAPDB::Install::Values::log->SetMsg("ACTION: copied file \"$src\" to \"$dst\"\n");
	return 1;
}


sub copyAscii{
	my ($srcFile,$dest) = @_;
	return copy($srcFile,$dest);
}



sub find {
        my ($dir,$type) = @_;
        my @returnvalue;
        -d $dir or return undef;
        opendir(DH,$dir) || return undef;
        my @content = readdir(DH);
        closedir(DH);

        my @files = grep { -f "$dir/$_" } @content;
        my @dirs = grep { -d "$dir/$_" && ! /^\.{1,2}$/} @content;


        foreach(@dirs){
                -l "$dir/$_" and next;
                my @result = find("$dir/$_",$type);
                defined @result && push @returnvalue,@result;
        }

        if($type !~ /^d$/i){
                foreach (@files){
                        push @returnvalue,"$dir/$_";
                }
        }
        if($type !~ /^f$/i){
                foreach (@dirs){
                        push @returnvalue,"$dir/$_";
                }
        }
        return @returnvalue;
}


sub makedir{
    #create directory recursively
    #on error return 0 else 1
    my $dir=(@_)[0]; #arg1: directoryname
	$dir=~s/\\/\//g;
	my $mode=(@_)[1];#arg2: accessrights
	my $uid=$_[2];#arg3: user id, if you dont want your effective user id -  else empty
	my $gid=$_[3];#arg4 group id, if you dont want your effective group id -  else empty
	$_=$dir;
    if($^O=~/.*mswin.*/i and ($dir=~/^[a-z]:[\\,\/]$/i)){
		return 1; #only drive name in path
	} 
	unless($dir){return 1;}
	($dir ne "/") and $dir=~s/\/$//;#remove slash at eol
	$_=$dir;
    my $tmp=$dir;
	unless(-d $dir){
		$tmp=~s/[^\/]*$//;
		makedir($tmp,$mode,$uid,$gid) or return 0;
		if(mkdir $dir , $mode){
			if (defined $mode and not $^O=~/mswin/i){
				chmod ($mode, $dir);
				my @statbuf = stat ($dir);
				my $filemode = $statbuf[2] & 0777;
				if ($filemode != $mode) {
					print2stderr("cannot change mode of directory \"$dir\" to ".sprintf('%o',$mode)."\n") and return 0;
				}
			}
			if($uid ne '' and $gid ne ''){
				chown($uid,$gid,$dir) or print2stderr("cannot change owner of directory \"$dir\"\n") and return 0;
			}
		}
		else{
			print2stderr("cannot create $dir\n");
			return 0;
		}
		defined $SAPDB::Install::Values::log &&  
		$SAPDB::Install::Values::log->SetMsg("ACTION: make directory \"$dir\" mode \"".sprintf('%o',$mode)."\" \n");
    }
    return 1;
}

#sub return user id from arg user name   
sub getuid{
    if($^O=~/MSWin.*/i){
		return 1;
	}
	else{
		return (getpwnam $_[0])[2];
	}
}

#sub return group id from arg group name
sub getgid{
    if($^O=~/MSWin.*/i){
		return 1;
	}
	else{
		return (getgrnam $_[0])[2];
	} 
}

sub changeOwner{
	if($^O=~/mswin/i){
		return 1;
	}
	my($owner,$group,$root,@list)=@_;
	#$owner: os user as string
	#$group: os group as string
	#$root: directory path, can be empty
	#@list: file list
	
	$#list == -1 and return 1;
	unless($owner and $group and $root){print2stderr("incorrect use of changeOwner()\n"); diesoft($SAPDB::Install::Values::diemsg);}
	-d $root or not $root or print2stderr("changeOwner(): directory \"$root\" not found\n") and diesoft($SAPDB::Install::Values::diemsg);
	my $uid=getuid($owner);
	($uid ne '') or print2stderr("changeOwner(): unknown os user\n") and diesoft("$SAPDB::Install::Values::diemsg");
	my $gid=getgid($group);
	($gid ne '') or print2stderr("changeOwner(): unknown os group\n") and diesoft("$SAPDB::Install::Values::diemsg");
	my $tmppath="start";
	foreach my $file (@list){
		my $relfile=$file;
		unless($file=~/^\/.*$/){
			if($root){
				$file="$root/$file";
			}
			else{
				$file="$SAPDB::Install::Values::curDir/$file";
			}
		}
		my $path=$relfile;
		$path=~s/(\/[^\/]*)$//; #remove filenname
		if($path ne $tmppath){
			changeOwnerForPath($path,$root);
			$tmppath=$path;	
		}
		chown($uid,$gid,$file) or print2stderr("changeOwner(): file \"$file\" failed\n") and diesoft($SAPDB::Install::Values::diemsg);
		$SAPDB::Install::Values::log->SetMsg("MSG: change ownership of file \"$file\"\n");
	}
	
	sub changeOwnerForPath{
		my $myPath=$_[0]; # path
		my $root=$_[1];

		my $nextPath = $myPath;

		$nextPath=~s/\/*[^\/]*$//;
		if ( $nextPath ) {
			changeOwnerForPath( $nextPath ,$root );
		}

		chown( $uid,$gid,$root."/".$myPath ) or print2stderr("changeOwnerForPath(): Directory \"$myPath\" failed\n") and diesoft($SAPDB::Install::Values::diemsg);

	}
}

sub checkFileInTGZ{
	my ($tgzfile,$file)=@_;
	-f $tgzfile or print2stderr("checkFileInTGZ(): tgz archive \"$tgzfile\" not found\n") and return 0;
	my $handle = SAPDB::Install::Untgz::new("$tgzfile");
	unless($handle){
		print2stderr("cannot open $tgzpackage\n") and diesoft($SAPDB::Install::Values::diemsg);
	}
	while(1){
		my $text=$handle->tgznext();
		unless($text){
			return 0;
		} 
		if($text=~/.*$file$/){
			return 1;
		}
	}
}

sub evalScriptInTGZ{
	my $script=$_[0]; # script to evaluate
	my $tgzpackage=$_[1]; # package with script 
	my $handle = SAPDB::Install::Untgz::new("$tgzpackage");
	unless($handle){
		print2stderr("cannot open $tgzpackage\n") and diesoft($SAPDB::Install::Values::diemsg);
	}
	while(1){
		my $text=$handle->tgznext();
		unless($text){
			print2stderr("cannot find script \"$script\" in package \"$tgzpackage\"\n") and diesoft($SAPDB::Install::Values::diemsg);
		} 
		if($text=~/.*$script$/){
			(my $rc,my $errtext)=$handle->tgzeval();
			if($errtext){
				print2stderr("tgzeval(): $errtext\n");
				($rc == -1 ) and print2stderr("cannot eval script \"$script\" in package \"$tgzpackage\"\n");
				diesoft($SAPDB::Install::Values::diemsg);
			}
			last;
		}
	}
	
}


sub checkServices{
	my $service_path;
	#get full path to services file
	if($^O=~/.*mswin.*/i){
		my %hash = SAPDB::Install::Registry::readValues(0,"SYSTEM\\CurrentControlSet\\Control\\Windows");
		unless($hash{'SystemDirectory'}){
			print2stderr("cannot find systemdirectory in windows registry\n");
			diesoft($SAPDB::Install::Values::diemsg);
		}
		$service_path="$hash{'SystemDirectory'}/drivers/etc/services";
		$service_path=~s/\\/\//g;			
	}
	else{
		$service_path="/etc/services";
	}
	
	-f $service_path or print2stderr("file $service_path not found\n") and diesoft($SAPDB::Install::Values::diemsg); 	
	open(SRV,$service_path) or print2stderr("cannot open \"$service_path\" to read\n") and diesoft($SAPDB::Install::Values::diemsg);
	
	my %port=(
		'sql6' => '7210/tcp',
		'sql30' => '7200/tcp',
		'sapdbni72' => '7269/tcp'
		);
	
	my %service_exist;
	
	#test etc/services for SAP DB Services
	
	while(<SRV>){
	   # print "TST $_\n";
	    foreach my $service (keys(%port)){
			if(/^$service\s/){
				$service_exist{$service}=1;
				$SAPDB::Install::Values::log->SetMsg("MSG: service \"$service\" in  \"$service_path\" found\n");
			}
		}
	}
	close(SRV);
	
	# append SAP DB services to etc/services
	
	open(SRV,">>$service_path") or print2stderr("cannot open \"$service_path\" to write\n") and diesoft($SAPDB::Install::Values::diemsg);
	foreach my $service (keys(%port)){
		unless($service_exist{$service}==1){
			print SRV "$service\t\t$port{$service}\n";
			$SAPDB::Install::Values::log->SetMsg("ACTION: append \"$service\" to $service_path\n");	
		}
	}
	close(SRV);
}




sub getSysTmpPath{
	if($^O=~/.*mswin.*/i){
		my %hash = SAPDB::Install::Registry::readValues(&SAPDB::Install::System::Win32::Registry::HKEY_CURRENT_USER,"Environment");
		my $returnvalue=$hash{'TMP'};
		$returnvalue=~s/\\/\//g;
		return $returnvalue;
	}
	else{
		return '/tmp';
	}
}




sub getSysProgPath{
	if($^O=~/.*mswin.*/i){
		my $prog_path;
		my %hash = readValues(0,"SOFTWARE\\Microsoft\\Windows\\CurrentVersion");
		unless($hash{'ProgramFilesDir'}){
			print2stderr("cannot find programfilesdir in windows registry\n");
			diesoft($SAPDB::Install::Values::diemsg);
		}
		$prog_path=$hash{'ProgramFilesDir'};
		$prog_path=~s/\\/\//g;
		return $prog_path;

	}
	else{
		return '/opt';
	}
}



sub normalizePath{
	my ($srPath)=@_;
	unless($^O=~/mswin/i){
		if(ref($srPath)){
			ref($srPath) ne 'SCALAR' and return;
			return 0;
		} 
		return $srPath;
	}
	if(ref($srPath)){
		ref($srPath) ne 'SCALAR' and return;
		my $rc=0;
		local *path = $srPath;
		$path=~s/\\/\//g and $rc=1;
		$path=~tr/[A-Z]/[a-z]/ and $rc=1;		
		return $rc;
	}
	else{
		my $returnvalue = $srPath;
		$returnvalue =~ s/\\/\//g;
		$returnvalue =~ tr/[A-Z]/[a-z]/;
		return $returnvalue;
	}

}



sub resolveLinks{
	my ($path,$depth) = @_;
	return $path if $^O =~ /mswin/i;
	$depth == 0 and return undef; 
	-e $path or return undef;
	my $new_path;
	foreach my $layer (split('/',$path)){
		if($layer eq ''){
			if ($new_path !~ /\S/){
				$new_path = '/' ;
			}
			else{
				next;
			}
		}
		if(-l $new_path.'/'.$layer){
			my $dest = readlink($new_path.'/'.$layer);
			$dest = genAbsPath($dest,$new_path);
			$new_path = resolveLinks($dest,$depth - 1); 
			defined $new_path or return undef;
		}
		else{
			$new_path .= '/'.$layer;
		}
		$new_path =~ s/\/{2,}/\//g;		
	}
	return $new_path;	 
}


sub genAbsPath{
	my ($file,$cwd) = @_;
	my $lcwd = ($cwd =~ /\S/) ? $cwd : $SAPDB::Install::Values::curDir; 
	my $lfile = normalizePath($file);
	unless($lfile =~ /^\// || ($^O =~ /mswin/i and $lfile=~ /^[a-z]:/i)){
		my $path = normalizePath($lcwd.'/'.$lfile);
		$lfile = $path;
	}	

	if($lfile =~ /\/\.{1,2}\//){
		my @path_stack;
		my $err;
		foreach my $dir (split('/',$lfile)){
			if($dir eq '.'){
				# do nothing
			}
			elsif($dir eq '..'){
				#remove tos element
				pop @path_stack or $err = 1 and last; 	
			}
			else{
				push @path_stack,$dir;
			}
		}
		if($err){
			return undef;
		}
		else{		
			my $tmp_path;
			foreach my $dir (@path_stack){
				$tmp_path .= (($^O =~ /mswin/i && $dir =~ /^[a-z]:$/) ? '' : '/' ) . $dir;
			}
			$lfile = $tmp_path;
		}
	}
	$lfile =~ s/\/{2,}/\//g;	
	return $lfile;
}


sub access{
	my ($node,$username,$access,$errout) = @_;
	$^O =~ /mswin/i and return 1;
	-e $node or $! = "no such file or directory" and return undef;
	my @passwd_buf = getpwnam($username);
	my $uid = $passwd_buf[2];
	my $prim_gid = $passwd_buf[3];
	defined $uid or $! = "unknown user" and return undef;
	$access =~ /^[rwx]{1,3}$/i or $! = "wrong access mode format" and return undef;  
	my @statbuf = stat ($node) or $! = "cannot stat: $!" and return undef;
	my $mode = $statbuf[2];
	my $check = 1;
	local *errbuf = $errout if ref($errout) eq 'ARRAY';
	if($statbuf[4] == $uid){
		
		# user is owner of node
		# check owner permissions

		if($access =~ /r/i){
			($mode & 0400) == 0 and push @errbuf,'owner has no r bit' and $check = 0;
		}
		if($access =~ /w/i){
			($mode & 0200) == 0 and push @errbuf,'owner has no w bit' and $check = 0;
		}
		if($access =~ /x/i){
			($mode & 0100) == 0 and push @errbuf,'owner has no x bit' and $check = 0;
		} 
		return $check;
	}
	
	
	# try to find username in group of node 
	my $found = 0;
	$prim_gid == $statbuf[5] and $found = 1; # group is primary group of user 
	foreach my $member (split(' ',(getgrgid($statbuf[5]))[3])){
		$found and last; # group is primary group of user
		$member eq $username and $found = 1 and last; 
	} 
	
	if($found){
		
		# found user in group of node
		# check group permissions
		
		if($access =~ /r/i){
			($mode & 040) == 0 and push @errbuf,'group has no r bit' and $check = 0;
		}
		if($access =~ /w/i){
			($mode & 020) == 0 and push @errbuf,'group has no w bit' and $check = 0;
		}
		if($access =~ /x/i){
			($mode & 010) == 0 and push @errbuf,'group has no x bit' and $check = 0;
		} 
		return $check;
	}
	else{

		# user is not owner and not member of group
		# check permissions for others
		
		if($access =~ /r/i){
			($mode & 04) == 0 and push @errbuf,'others have no r bit' and $check = 0;
		}
		if($access =~ /w/i){
			($mode & 02) == 0 and push @errbuf,'others have no w bit' and $check = 0;
		}
		if($access =~ /x/i){
			($mode & 01) == 0 and push @errbuf,'others have no x bit' and $check = 0;
		} 
		return $check;
	}

}

sub setPathInEnv{
	my ($path) = @_;
	my $pattern = $path;
	if($^O =~ /mswin/i){
		$pattern =~ s/\//\\/g;
		$pattern =~ s/\\/\\\\/g;
		$pattern = '^'.$pattern.';|;'.$pattern.';|;'.$pattern.'$';	 	
	}
	else{
		$pattern =~ s/\//\\\//g;
		$pattern = '^'.$pattern.':|:'.$pattern.':|:'.$pattern.'$';
	}
	
	if(($^O =~ /mswin/i && $ENV{'PATH'} =~ /$pattern/i) || $ENV{'PATH'} =~ /$pattern/){
			TraceMsg("$path in \$PATH found\n",3,\$DEBUG);
	}
	else{
		TraceMsg("$path in \$PATH set\n",3,\$DEBUG);
		if($^O =~ /mswin/i){
			$path =~ s/\//\\/g;
			$path .= ';';
		}
		else{
			$path .= ':';
		}
		$ENV{'PATH'} = $path.$ENV{'PATH'};
	}
	return 1;
}



sub getSysPath{
	unless($^O =~ /mswin/i){
		# windows only
		return undef;
	}
	my %hash = readValues(0,'SYSTEM\CurrentControlSet\Control\Windows');
	unless($hash{'SystemDirectory'}){
		print2stderr("cannot find system directory inside windows registry\n");
		diesoft($SAPDB::Install::Values::diemsg);
	}
	return $hash{'SystemDirectory'};
}


sub getAppDataPath{
	if($^O =~ /mswin/i){
		my %hash = readValues(0,'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders');
		unless($hash{'Common AppData'}){
			print2stderr("cannot find application data directory inside windows registry\n");
			diesoft($SAPDB::Install::Values::diemsg);
		}
		return $hash{'Common AppData'};	
	}
	else{
		return '/var/opt';
	}
}


sub instWinSysFiles{
	local ($tgz,$path,$files) = @_;
	$path =~ s/\\/\//g;
	unless($^O =~ /mswin/i){
		return undef;
	}
	print2stdout("checking system libraries...");
	-d $path or print2stderr("instWinSysFiles(): system path \"$path\" not found\n") and return undef; 
	my (@check_update,@install_files);
	foreach my $file (@$files){
		if (-f "$path/$file"){
			my $fname = "$path/$file";
			$fname =~ s/\//\\/g; 
			if(SAPDB::Install::System::Win32::API::SfcIsFileProtected($fname)){
				$SAPDB::Install::Values::log->SetMsg("MSG: file \"$fname\" is under system file protection\n");
			}
			else{
				push @check_update, $file;
			}
		}  
		else{
			push @install_files, $file;
		} 
	}
	
	my $check_num = $#check_update; 
	
	my %file_found;
	foreach my $file (@$files){
		$file_found{$file} = 0;
	}


	if($check_num > -1){
		$tgz->Rewind();
		my $info = "start"; 
		my @errors;
		while($info){
			$info = $tgz->Next();
			#print ">>>>> $info\n";
			last unless $info;
			my ($pattern) = ($info =~ /\s(\S+)$/);
			$pattern =~ s/^\.\///;
			$pattern =~ s/\/|\\/\\\//g;
			$pattern =~ s/\./\\\./g;
			$pattern = '^'.$pattern.'$';
			foreach my $file (@check_update){
				if($file =~ /$pattern/i){
					$file_found{$file} = 1;
					my $fname = "$path/$file";
					$SAPDB::Install::Values::log->SetMsg("MSG: update test sytem file \"$fname\"\n");
					my $myversion = $tgz->ExtractSysVersionInfo;
					if($tgz->GetErr){
						push @errors ,"cannot get version of file \"$file\" inside archive: ".(join(': ',$tgz->GetErr))."\n";
						next;
					}
					$SAPDB::Install::Values::log->SetMsg("MSG: system file \"$file\" inside archive has version $myversion\n");					
					
					my $theirversion= SAPDB::Install::System::Win32::VersionInfo::SysVersionInfo($fname);
					unless(defined $theirversion){
						push @errors, "cannot get version of file \"$fname\"\n";
						next;
					}
					$check_num--;
					
					join (".", @build); 
					if(release2num($theirversion) < release2num($myversion)){
						$SAPDB::Install::Values::log->SetMsg("MSG: installed system file \"$file\" (version $theirversion) has to be updated\n");
						push @install_files,$file;
					}
					else{
						$SAPDB::Install::Values::log->SetMsg("MSG: installed system file \"$file\" is up to date (version $theirversion)\n");
					}
				}
			}
			last if $check_num == -1;		
		}	
		if($check_num == -1){
			print2stdout(" ok\n");
		}
		else{
			print2stdout(" failed\n");
			#print2stderr("WRN: not all system libs were checked\n");
			foreach my $file (@check_update){
				print2stderr("file \"$file\" not found in archive\n") unless $file_found{$file};
			}
			foreach my $errmsg (@errors){
				print2stderr("$errmsg");
			}
			diesoft($diemsg);
		}
	}
	else{
		print2stdout(" ok\n");
	}

	
	my $install_num = $#install_files; 

	if($install_num > -1){
		print2stdout("installing system libraries...");
		$tgz->SetDestDir($path);
		$tgz->Rewind();
		$tgz->SetReadOnly(0);
		my $info = "start"; 
		my @errors;
		while($info){
			$info = $tgz->Next();
			last unless $info;
			my ($pattern) = ($info =~ /\s(\S+)$/);
			$pattern =~ s/^\.\///;
			$pattern =~ s/\/|\\/\\\//g;
			$pattern =~ s/\./\\\./g;
			$pattern = '^'.$pattern.'$';
			foreach my $file (@install_files){
				if($file =~ /$pattern/i){
					if(-f "$path/$file"){					
						if(open(tmpFD,'+<'."$path/$file" )){
							close(tmpFD);
						}
						else{
							$SAPDB::Install::Values::log->SetMsg("MSG: cannot open \"$path/$file\" for writing: $! - moving it now\n");
							killUsedFiles("$path/$file");
						}
					}
					$file_found{$file} = 1;
					$tgz->ExtractFile;
					if($tgz->GetErr){
						push @errors ,"cannot extract file \"$path/$file\": ".(join(': ',$tgz->GetErr))."\n";
					}
					else{
						$SAPDB::Install::Values::log->SetMsg("MSG: $info extracted\n");
						$install_num--;
					}
				}	
			}
			last if $install_num == -1;		
		}	
		if($install_num == -1){
			print2stdout(" ok\n");
		}
		else{
			print2stdout(" failed\n");
			#print2stderr("WRN: not all system libs were installed\n");
			foreach my $file (@install_files){
				print2stderr("file \"$file\" not found in archive\n") unless $file_found{$file};
			}
			foreach my $errmsg (@errors){
				print2stderr("$errmsg");
			}
			diesoft($diemsg);
		}
	}
			
	return 1;
}


sub unbusy{
	my (@files) = @_;
	unless($^O =~ /mswin/i){
		foreach my $file (@files){
			next unless -f $file;
			if(open(FD,'+<'.$file)){
				close(FD);
				$SAPDB::Install::Values::log->SetMsg("$file isn\'t busy\n");
			}
			else{
				$SAPDB::Install::Values::log->SetMsg("$file is busy\n");
				rename($file,$file.'.run');
				if(copy($file.'.run',$file,{'binmode' => 1})){
					$SAPDB::Install::Values::log->SetMsg("deleting ${file}.run\n");
					if($^O =~ /hpux/i){
						my $rmfile = $SAPDB::Install::Values::indep_prog_path.'/pgm/rmfile';
						if (-x $rmfile){
							callsystem("$rmfile ".$file.'.run',sub {return 1});
						}
						else{
							$SAPDB::Install::Values::log->SetMsg("WRN: tool rmfile not found\n");
						}
					}
					else{
						unlink($file.'.run') or $SAPDB::Install::Values::log->SetMsg("cannot delete ${file}.run\n");
					}
				}
				else{
					print2stderr("cannot copy file\n");
					rename($file.'.run',$file);
				}
			} 
		}
	}	
	return 1;
}




sub checkrpm{
    if($^O eq 'linux'){
	$_=`rpm`;
	$? != 0 and $SAPDB::Install::Values::log->SetMsg("MSG: checkrpm: $_") and return 1;
	if(/usage:/){
	    $_=`rpm -q sapdb-ind 2>&1`;
	    unless (/.*not\ installed.*/){
		print2stderr("SAPDB with \"rpm\" installed\n");
		diesoft($SAPDB::Install::Values::diemsg);
	    } 
	}
	
    }
}
1;