#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/b_07/sys/src/install/perl/SAPDB/Install/SysInfo.pm#1 $
# $DateTime: 2003/11/20 17:48:59 $
# $Change: 57359 $
#

package SAPDB::Install::SysInfo;

sub import {
	local $SAPDB::Install::Exporter::ExportLevel = 1;
	SAPDB::Install::Exporter::import (@_);

	bootstrap SAPDB::Install::SysInfo;
}

sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ('GetSystemInfo','IsRunnable');
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Exporter', 'PipeExec'
	);
	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval
		("SAPDB::Install::$package", 1.01)) {
                	print join ("\n", $repo->GetErr)."\n";
                	die;
        	}
		import ("SAPDB::Install::$package"); 
	}
}

sub AUTOLOAD {
	die unless ($AUTOLOAD =~ "bootstrap");
	require DynaLoader;
	push @ISA, 'DynaLoader';
	bootstrap SAPDB::Install::SysInfo;
}

#
# main
#
sub main {
	return (SAPDB::Install::SysInfo::Test::main (@_));
}

package SAPDB::Install::SysInfo::Test;

$DEBUG = 0;

sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ();
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Getopt::Long'
	);

	foreach my $package (@neededPackages) {
		unless (defined $repo->Eval
		("SAPDB::Install::$package", 1.01)) {
			print join ("\n", $repo->GetErr)."\n";
			die;
		}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	}
}

sub main {
	my $sysinfo = SAPDB::Install::SysInfo::GetSystemInfo ();

	if (exists $sysinfo->{'system'}) {
		print "System        : ".$sysinfo->{'system'}."\n";
	}

	if (exists $sysinfo->{'architecture'}) {
		print "Architecture  : ".$sysinfo->{'architecture'}."\n";
	}

	if (exists $sysinfo->{'version'}) {
		print "Version       : ".$sysinfo->{'version'}."\n";
	}

	if (exists $sysinfo->{'subversion'}) {
		print "Subversion    : ".$sysinfo->{'subversion'}."\n";
	}

	if (exists $sysinfo->{'c_runtime'}) {
		print "C Runtime     : ".$sysinfo->{'c_runtime'}."\n";
	}

	if (exists $sysinfo->{'cpp_runtime'}) {
		print "C++ Runtime   : ".$sysinfo->{'cpp_runtime'}."\n";
	}

	if (exists $sysinfo->{'cpp_runtime64'}) {
		print "C++ Runtime 64: ".$sysinfo->{'cpp_runtime64'}."\n";
	}

	return 0;
}

1;

