#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/b_07/sys/src/install/perl/SAPDB/Install/SigHandler.pm#1 $
# $DateTime: 2003/11/20 17:48:59 $
# $Change: 57359 $
#
# Desc: 

package SAPDB::Install::SigHandler;


$VERSION = 1.01;

sub BEGIN {
        
       @ISA = ('SAPDB::Install::Exporter');
	 @EXPORT = ('setSigHandler');

	  my $repo = SAPDB::Install::Repository::GetCurrent ();
        my @neededPackages=(
	  	'Exporter',
		'StdIO',
		'Trace'
	   );
	  foreach my $package (@neededPackages){
	  	unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                print join ("\n", $repo->GetErr)."\n";
                die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	  } 
}


sub setSigHandler{
	
	$SIG{'INT'} = sub {
					print2stderr("\nCtrl + c pressed!\n");
					defined $SAPDB::Install::StartInstall::cleaner and $SAPDB::Install::StartInstall::cleaner->DESTROY and $SAPDB::Install::StartInstall::cleaner=undef;
					defined $SAPDB::Install::Uninstall::Start::cleaner and $SAPDB::Install::Uninstall::Start::cleaner->DESTROY and $SAPDB::Install::Uninstall::Start::cleaner=undef;
					diesoft('aborted');
				 };
	
	foreach my $errsig ('ABRT','BUS','EMT','FPE','ILL','QUIT','SEGV','SYS','TRAP'){
		
		$SIG{$errsig} = sub {
						print2stderr("SIGNAL: got signal $errsig\n");
						WriteTrace();
						defined $SAPDB::Install::StartInstall::cleaner and $SAPDB::Install::StartInstall::cleaner->DESTROY and $SAPDB::Install::StartInstall::cleaner=undef;
						defined $SAPDB::Install::Uninstall::Start::cleaner and $SAPDB::Install::Uninstall::Start::cleaner->DESTROY and $SAPDB::Install::Uninstall::Start::cleaner=undef;
						diesoft('fatal error');
	
					};
	}
	
}

1;