#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/b_07/sys/src/install/perl/SAPDB/Install/SetDebug.pm#1 $
# $DateTime: 2003/11/20 17:48:59 $
# $Change: 57359 $
#
# Desc: module set $DEBUG vars for loaded modules using --debug option



package SAPDB::Install::SetDebug;





$VERSION = 1.01;

sub BEGIN {
    @ISA=('SADB::Install::Exporter');
	@EXPORT=('SetDebug','printSymbols'); 
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages=(
		'Exporter',
		'Getopt::Long',
		'Trace',
		'StdIO'
	);
	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                print join ("\n", $repo->GetErr)."\n";
                die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	}
}



sub SetDebug{
	local (*ARGV)=@_;
	# keep unused argument in @ARGV
	SAPDB::Install::Getopt::Long::Configure ('pass_through');
	%opt_ctrl=(
		'debug=s' => \$debug,
		'trace=s'  => \$trace
	);
	GetOptions(%opt_ctrl);
	if(defined $debug){
		my @packs = split(' ',$debug);
		foreach my $packname (@packs){
			defined %{"SAPDB::Install::${packname}::"} or print "SetDebug: module \"SAPDB::Install::$packname\" dont exist\n" and next;
			${"SAPDB::Install::${packname}::DEBUG"}=1;
		}
	}
	
	if(defined $trace){
		$trace =~ /\D/ and print2stderr("non numeric character in trace option found - remove\n");
		$trace =~ s/\D//g;
		$trace =~ /\d+/ or print2stderr("no valid trace level set\n") and return 1;
		$trace >= 0 and $trace < 6 or print2stderr("trace level out of range - set it to 5\n") and TraceLevel(5) and return 1;
		TraceLevel($trace);
	}	

	
}

sub printSymbols{
        my ($arg_package)=@_;
        my ($package,$module,$line)=caller unless defined $package;
        defined $arg_package and $package=$arg_package;
        defined %{"${package}::"} || print "module $package unkown\n" && return; 
        foreach my $symname  (keys(%{"${package}::"})){
               my $found = 0;
               print "\$$package\::$symname = ".${${%{"${package}::"}}{$symname}}."\n" and $found = 1 if defined ${"${package}::$symname"};
               print "\@$package\::$symname = ".@{${%{"${package}::"}}{$symname}}."\n"  and $found = 1 if defined @{"${package}::$symname"};
               print "\%$package\::$symname = ".%{${%{"${package}::"}}{$symname}}."\n"  and $found = 1 if defined %{"${package}::$symname"};
               print "\&$package\::$symname  is defined\n" and $found = 1 if defined &{"${package}::$symname"};
               $found || print "\*$symname\n";
        }
}


1;