#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/b_07/sys/src/install/perl/SAPDB/Install/Registry.pm#1 $
# $DateTime: 2003/11/20 17:48:59 $
# $Change: 57359 $
#
# Desc: 


package SAPDB::Install::Registry;

$VERSION = 1.01;

        


sub BEGIN {
		@ISA = ('SAPDB::Install::Exporter');
        @EXPORT = ('getmax', 'getInstalledReleases', 'readRuntimes','removeKey',
		'readIndepPath','readValues','readSubKeys','createUninstallEntry','removeUninstallEntry','setRenamedFiles',
		'readini','writeini','setSysPath','createKey','getInstances','deleteSAPDBTech','removeFromSysPath','readGlobals');
		my $repo = SAPDB::Install::Repository::GetCurrent ();
		my @neededPackages=(
			'StdIO',
			'System',
			'SetUser',
			'Values',
			'Tools',
			'Trace'
		);
		$^O=~/mswin/i and push @neededPackages,'System::Win32::Registry'; 
		foreach my $package (@neededPackages){
			unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                		print join ("\n", $repo->GetErr)."\n";
                		die;
        		}
			SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
		} 
		        
}

sub readini{
	# sub return such a hash : $hash{$SECTION}{$KEY}=$VALUE;
	# $SECTION - in ini file something like this: [my section]
	# $KEY - in ini file  something like this: my key = xxxxx
	# $VALUE - in ini file something like this: xxxx = my value
	my $file=$_[0]; # full path to ini file
	my %returnvalue;
	-f $file or $SAPDB::Install::Values::log->SetMsg("readini(): file \"$file\" not found\n") and return;
	open(INI,$file) or $SAPDB::Install::Values::log->SetMsg("readini(): cannot open file \"$file\"\n") and return;
	my $section;
	while(my $line=<INI>){
		chomp($line);
		$_=$line;
		/^[\ ]*\[(\S.*\S)\][\ ]*$/ and $section=$1;
		/[\ ]*(\S.*\S)[\ ]*=[\ ]*(.*)/ and $returnvalue{$section}{$1}=$2;
	}
	close(INI);
	unless(%returnvalue){
		$SAPDB::Install::Values::log->SetMsg("readini(): no values found in file \"$file\"\n");
		return;
	}
	return %returnvalue;
}

sub writeini{
	my ($file,$args)=@_;
	my %data = (); 
	my $exists = 0;
	my @statbuf;
	if(-f $file){
		$exists = 1;
		@statbuf = stat($file);
		%data = readini($file);
	}
	
	if($args->{'add_key'}){
		foreach my $section (keys(%{$args->{'add_key'}})){
			my %values = ();
			if(exists $data{$section} and ref($data{$section}) eq 'HASH'){
				%values = %{$data{$section}};
			}
			foreach my $key (keys(%{$args->{'add_key'}->{$section}})){
				$values{$key} = $args->{'add_key'}->{$section}->{$key};
			}
			$data{$section} = \%values;
		}
	}

	if($args->{'delete_key'}){
		foreach my $section (keys(%{$args->{'delete_key'}})){
			my %values = ();
			if(exists $data{$section} and ref($data{$section}) eq 'HASH'){
				%values = %{$data{$section}};
			}
			foreach my $key (keys(%{$args->{'delete_key'}->{$section}})){
				delete $values{$key};
			}
			$data{$section} = \%values;
		}
	}

	open(FD,'>'.$file.($exists ? '.sdbtmp' : '')) or $SAPDB::Install::Values::log->SetMsg("ERR: writeini(): cannot open/create file \"$file".($exists ? '.sdbtmp' : '')."\"\n") and return 0;
	foreach my $section (keys(%data)){
		print FD "[$section]\n";
		my %inner = %{$data{$section}};
		foreach my $valuename (keys(%inner)){
			print FD "$valuename=$inner{$valuename}\n";
		}
	}
	close (FD);
	if($exists){
		unlink($file);
		rename("$file.sdbtmp",$file);
		unless($^O =~ /mswin/i){
			chmod($statbuf[2],$file) or
				print2stderr("writeini(): cannot mode of $file\n");
			chown($statbuf[4],$statbuf[5],$file) or
				print2stderr("writeini(): cannot change owner of $file\n");
		}
	}
	return 1;
}


sub readValues{
	#sub retrun hash of values
	my $root=$_[0];
	unless($root){
		 $root = &HKEY_LOCAL_MACHINE;
	}
	my $keyname=$_[1];
	my $notexpand=$_[2];# true -> dont expand expandstring 
	(RegOpenKeyEx($root, $keyname, 0, &KEY_READ , $key ) == 0) 
	or  $SAPDB::Install::Values::log->SetMsg("Can't open registry key \"HKEY_LOCAL_MACHINE\\$keyname\": $!\n") and return;
	my $i=0;
	my %returnvalue;
	RegQueryInfoKey ($key, 0, 0, 0, 0, 0, 0, $ValCount, 0, 0, 0, 0);
	for ($index = 0; $index < $ValCount; $index++){
		RegEnumValue( $key, $index ,$sValName, 0, 0, $piType, $pValData, 0 );
		if(Win32::GetLastError()==259){last;}
		if($piType==&REG_BINARY){
			$pValData=unpack("H*",$pValData);	
		}
		elsif($piType==&REG_EXPAND_SZ and not $notexpand){
			ExpandEnvironmentStrings($pValData,$pValData,0);
		}
		$returnvalue{$sValName}=$pValData;
	}
	(RegCloseKey( $key ) == 0) or $SAPDB::Install::Values::log->SetMsg("Can't close registry key \"$root\\$keyname\": $!\n");
	return %returnvalue;
}


sub removeIndepPaths{
	(RegOpenKeyEx(&HKEY_LOCAL_MACHINE, 'SOFTWARE\SAP\SAP DBTech', 0, &KEY_ALL_ACCESS , $key ) == 0)
	or $SAPDB::Install::Values::log->SetMsg("WRN: Can't open \"HKEY_LOCAL_MACHINE\\Software\\SAP\\SAP DBTech\" : $!\n") and return 0;
	(RegDeleteValue($key,'IndepData')==0) or $SAPDB::Install::Values::log->SetMsg("WRN: cannot delete Value \"HKEY_LOCAL_MACHINE\\Software\\SAP\\SAP DBTech\\IndepData\" : $!\n") and return 0;
	(RegDeleteValue($key,'IndepPrograms')==0) or $SAPDB::Install::Values::log->SetMsg("WRN: cannot delete Value \"HKEY_LOCAL_MACHINE\\Software\\SAP\\SAP DBTech\\IndepPrograms\" : $!\n") and return 0;
	$SAPDB::Install::Values::log->SetMsg("MSG: removed IndepPaths successfully from windows registry\n");
	(RegCloseKey( $key ) == 0) or $SAPDB::Install::Values::log->SetMsg("Can't close registry key \"HKEY_LOCAL_MACHINE\\SOFTWARE\\SAP\\SAP DBTech\": $!\n");
	return 1;

}


sub deleteSAPDBTechWin{
	removeIndepPaths();
	(RegOpenKeyEx(&HKEY_LOCAL_MACHINE, 'Software\SAP', 0, &KEY_ALL_ACCESS , $key ) == 0) 
	or $SAPDB::Install::Values::log->SetMsg("WRN: Can't open \"HKEY_LOCAL_MACHINE\\Software\\SAP\" : $!\n") and return 0;
	(RegDeleteKey($key,'SAP DBTech')==0) or $SAPDB::Install::Values::log->SetMsg("WRN: cannot delete \"HKEY_LOCAL_MACHINE\\Software\\SAP\\SAP DBTech\" : $!\n") and return 0;
	$SAPDB::Install::Values::log->SetMsg("MSG: cleaned windows registry successfully\n");
	return 1;
}

sub deleteSAPDBTechUX{
	if(-f $SAPDB::Install::Values::ini_path){
		unlink($SAPDB::Install::Values::ini_path) or $SAPDB::Install::Values::log->SetMsg("WRN: cannot delete \"$SAPDB::Install::Values::ini_path\"\n");
	}
	else{
		$SAPDB::Install::Values::log->SetMsg("WRN: cannot delete \"$SAPDB::Install::Values::ini_path\" - file dont exist\n");
	}
	if(-f $SAPDB::Install::Values::glob_path){
		unlink($SAPDB::Install::Values::glob_path) or $SAPDB::Install::Values::log->SetMsg("WRN: cannot delete \"$SAPDB::Install::Values::glob_path\"\n");
		my ($path) = ($SAPDB::Install::Values::glob_path =~ /(^.+)\/[^\/]+$/);
		removeEmptyDirs($path) if $path =~ /\S/;
	}
	else{
		$SAPDB::Install::Values::log->SetMsg("WRN: cannot delete \"$SAPDB::Install::Values::glob_path\" - file dont exist\n");
	}
	
	$SAPDB::Install::Values::log->SetMsg("MSG: removed SAP DB Registry successfully\n");
	return 1;
}


*deleteSAPDBTech = 
	$^O =~ /^mswin/i ? \&deleteSAPDBTechWin :
	\&deleteSAPDBTechUX;




sub setSysPath{
	# sub set system PATH in windows registry
	my $appendString = $_[0]; # string to extend system path
	unless($^O=~/.*mswin.*/i){
		return 1;
	}
	my $keyname="SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment";
	my %values = readValues(&HKEY_LOCAL_MACHINE,$keyname,1);
	$appendString=~s/\//\\/g; # replace "/" with "\"
	my $testString=$appendString;
	$testString=~s/\\/\\\\/g; # replace "\" with "\\" for pattern matching
	my $path;
	foreach my $keyname (keys(%values)){
		$keyname=~/^path$/i and $path=$keyname;
	}
	unless($path){
		print2stderr("setSysPath(): real name of \"path\" not found\n");
		return 0;
	}
	if($values{$path}=~/$testString/i){
		$SAPDB::Install::Values::log->SetMsg("MSG: SYSTEM PATH is up to date\n");
		return 2;
	}
	$appendString="$appendString;$values{$path}";
	(RegOpenKeyEx(&HKEY_LOCAL_MACHINE, $keyname, 0, &KEY_SET_VALUE, $key ) == 0) 
	or  print2stderr("setSysPath(): cannot open HKEY_LOCAL_MACHINE\\$keyname: $!\n") and return 0;
	(RegSetValueEx($key,$path,0,&REG_EXPAND_SZ,$appendString,0)==0) or print2stderr("setSysPath(): cannot set value\n") and return 0;
	print2stdout("system path updated successfully\n");
	print2stdout("please reboot your system after installation to take effect changes\n");
	(RegCloseKey($key)==0) or print2stderr("setSysPath(): cannot close HKEY_LOCAL_MACHINE\\$keyname\n");
	return 1;
}


sub removeFromSysPath{
	my ($removeString) = @_; # string to remove from system path
	$^O=~/mswin/i or return 1;
	my $keyname="SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment";
	my %values = readValues(&HKEY_LOCAL_MACHINE,$keyname,1);
	$removeString=~s/\//\\/g; # replace "/" with "\"
	my $testString=$removeString;
	$testString=~s/\\/\\\\/g; # replace "\" with "\\" for pattern matching
	my $path;
	foreach my $keyname (keys(%values)){
		$keyname=~/^path$/i and $path=$keyname;
	}
	unless($path){
		print2stderr("removeFromSysPath(): real name of \"path\" not found\n");
		return 0;
	}
	if($values{$path}=~/$testString/i){
		$SAPDB::Install::Values::log->SetMsg("MSG: SAP DB paths found in PATH\n");
	}
	else{
		$SAPDB::Install::Values::log->SetMsg("MSG: SAP DB paths not found in PATH\n");
		return 1;
	}
	my $newValue = $values{$path};
	$newValue =~ s/$testString;*//i;
	(RegOpenKeyEx(&HKEY_LOCAL_MACHINE, $keyname, 0, &KEY_SET_VALUE, $key ) == 0) 
	or  print2stderr("removeFromSysPath(): cannot open HKEY_LOCAL_MACHINE\\$keyname: $!\n") and return 0;
	(RegSetValueEx($key,$path,0,&REG_EXPAND_SZ,$newValue,0)==0) or print2stderr("removeFromSysPath(): cannot set value\n") and return 0;
	print2stdout("system path cleaned successfully\n");
	print2stdout("please reboot your system after uninstallation to take effect changes\n");
	(RegCloseKey($key)==0) or print2stderr("removeFromSysPath(): cannot close HKEY_LOCAL_MACHINE\\$keyname\n");
	return 1;
	
}


sub readSubKeys{
	#return array of sub keys
	my $root=$_[0];
	my $keyname=$_[1];
	unless($root){
		$root=&HKEY_LOCAL_MACHINE;
	}
	(RegOpenKeyEx($root, $keyname, 0, &KEY_READ , $key ) == 0) 
	or $SAPDB::Install::Values::log->SetMsg("Can't open registry key \"HKEY_LOCAL_MACHINE\\$keyname\": $!\n") and return; 
	my $i=0;
	my @returnvalue;
	RegQueryInfoKey ($key, 0, 0, 0, my $KeyCount, 0, 0, 0, 0, 0, 0, 0);
	for (my $index = 0; $index < $KeyCount; $index++){
		RegEnumKeyEx($key , $index, $sName, 0, 0, 0, 0,0 );
		if(Win32::GetLastError()==259){last;}
		push(@returnvalue,$sName);		
		
	}
	(RegCloseKey( $key ) == 0) or $SAPDB::Install::Values::log->SetMsg("Can't close registry key \"$root\\$keyname\": $!\n");
	return @returnvalue;
}



sub createKey{
	# sub create key in registry recursively
	my $hkey = $_[0]; # HKEY_* 
	my $key = $_[1];  # keyname
	unless($hkey){
		$hkey=&HKEY_LOCAL_MACHINE;
	}
	$key=~ /^[^\\]*$/ and return 1; # cant create first level key
	my $tmpkey=$key;
	$tmpkey=~s/^(.*)\\[^\\]{1,}$/$1/;
	createKey($hkey,$tmpkey) or return 0;
	(RegCreateKeyEx($hkey,$key,0,0,&REG_OPTION_NON_VOLATILE ,&KEY_CREATE_SUB_KEY  ,0,$newkey,$piDisp)==0) or print2stderr("createKey(): cannot create subkey \"$key\"\n") and return 0;
	(RegCloseKey($newkey)==0) or $SAPDB::Install::Values::log->SetMsg("WRN: createKey(): cannot close new subkey \"$key\"\n");
	if($piDisp==&REG_CREATED_NEW_KEY){
		$SAPDB::Install::Values::log->SetMsg("MSG: created registry subkey \"$key\" successfully\n");
	}
	elsif($piDisp==&REG_OPENED_EXISTING_KEY){
		$SAPDB::Install::Values::log->SetMsg("MSG: registry subkey \"$key\" exist\n");
	}
	return 1;
}


sub removeKey{
	my ($hRoot,$keyname,$mode)=@_;
	
	local *root = $hRoot;	
	
	#
	# modes:	0 -> remove only if key is empty
	#			1 -> remove it with all empty subkeys
	#			2 -> remove it with all subkeys and values
	#		  
	
	unless(exists $root{'handle'} and defined $root{'handle'}){
		eval{
			$root{'handle'} = &{$root{name}};  
		};$@ and $SAPDB::Install::Values::log->SetMsg("unknown registry root \"{$root{name}\": $@\n") and return 0;
	}

	if($mode == 2){
		my %values = readValues($root{'handle'},$keyname);
		my $key;
		(RegOpenKeyEx($root{'handle'},$keyname, 0, &KEY_ALL_ACCESS , $key ) == 0)
			or $SAPDB::Install::Values::log->SetMsg("WRN: Can't open \"$root{'name'}\\$keyname\" : $!\n") and return 0;
		foreach my $value_name (keys(%values)){
			(RegDeleteValue($key,$value_name) == 0) 
				or $SAPDB::Install::Values::log->SetMsg("WRN: cannot delete Value \"$root{'name'}\\$keyname\\$value_name\" : $!\n") and return 0;
		}
		(RegCloseKey( $key ) == 0) or $SAPDB::Install::Values::log->SetMsg("Can't close registry key \"$root{'name'}\\$keyname\": $!\n");
	}
	if($mode >= 1){
		my @subkeys = readSubKeys($root{'handle'},$keyname);
		foreach my $subkey (@subkeys){
			removeKey($hRoot,"$keyname\\$subkey",$mode) or return 0;
		} 
	}
	if($mode >= 0){
		my ($parent_keyname,$subkeyname) = ($keyname =~ /^(.*)\\([^\\]+)\\{0,1}$/);
		my $key;
		
		(RegOpenKeyEx($root{'handle'},$parent_keyname, 0, &KEY_ALL_ACCESS , $key ) == 0)
			or $SAPDB::Install::Values::log->SetMsg("WRN: Can't open \"$root{'name'}\\$parent_keyname\" : $!\n") and return 0;
		
		(RegDeleteKey($key,$subkeyname)==0)
			or $SAPDB::Install::Values::log->SetMsg("WRN: cannot delete \"$root{'name'}\\$parent_keyname\\$subkeyname\" : $!\n") and return 0;
		
		(RegCloseKey( $key ) == 0)
			or $SAPDB::Install::Values::log->SetMsg("Can't close registry key \"$root{'name'}\\$parent_keyname\": $!\n");
	}
	return 1;
}




#sub return max from arg list
sub getmax{
    local %tmp=@_;
    $max=0;
    my $rel;
	foreach  $rel (%tmp){
		if($rel > $max){
		    $max=$rel;
		}
    }
    return $max;
}

#sub reads releases and dbroots from ini file
sub getInstalledReleasesUX{
    my %returnvalue;
    my $indep_data = (readIndepPath())[0];
	foreach my $path ($indep_data.'/config/Installations.ini',$SAPDB::Install::Values::ini_path){
		if(-f $path){
			my %hash = readini($path);
			return undef unless defined %hash;
			foreach $inst (keys( %{$hash{'Installations'}})){
				next if exists $returnvalue{$inst};
				$_=$hash{'Installations'}{$inst};	
				/([0-9][0-9]*\.[0-9][0-9]*\.[0-9][0-9]*\.[0-9][0-9]*),/ and $returnvalue{$inst}=$1;
			}
		}	
	}
	
	foreach $dbroot (keys %returnvalue){
			my $release=getRelease("$dbroot/pgm/kernel");
			if($release){
				$returnvalue{$dbroot}=$release;
			}
	}
	return %returnvalue;
}


sub getInstancesUX{
	my %returnvalue;
	my $indep_data = (readIndepPath())[0];
	foreach my $path ($indep_data.'/config/Databases.ini',$SAPDB::Install::Values::ini_path){
		if(-f $path){
			my %hash=readini($path);
			my $tmp=$hash{'Databases'};
			my %dbroot=%$tmp;
			foreach my $db (keys(%dbroot)){
				#filter service databases ( '_' for < 7.4 )
				unless($db=~/^_/ || $db=~/^\./){
						$returnvalue{$db}= $dbroot{$db} unless exists $returnvalue{$db};
				}
			}
		}	
	}
	return %returnvalue;
}


sub getInstancesWin{
	#HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\SAP DBTech-TST
	my @subkeys = readSubKeys(0,'SYSTEM\CurrentControlSet\Services');
	my %returnvalue;
	foreach my $subkey (@subkeys){
		my $key=$subkey;
		if($subkey=~s/^SAP\ DBTech-//){

			#filter service databases ( '_' for < 7.4 )
			unless($subkey=~/^_/ || $subkey=~/^\./){
				$returnvalue{$subkey}=$key;
			
			}
		}
	}
	foreach my $db (keys(%returnvalue)){
		my %values = readValues(0,"SYSTEM\\CurrentControlSet\\Services\\$returnvalue{$db}");
		$returnvalue{$db}=$values{'ImagePath'};
		$returnvalue{$db}=~s/\\/\//g;
		$returnvalue{$db}=~s/\/pgm\/kernel.exe//;
	}
	return %returnvalue;
}


*getInstances = 
	$^O =~ /^MsWin/i ? \&getInstancesWin :
	\&getInstancesUX;



sub readRuntimesUX{
	my %returnvalue;
	my $indep_data = (readIndepPath())[0];
	foreach my $path ($indep_data.'/config/Runtimes.ini',$SAPDB::Install::Values::ini_path){
		next unless -f $path;
		my %hash = readini($path) or print2stderr("cannot read $path\n") and return;
		my %releases = %{$hash{'Runtime'}};
		foreach my $rpath (keys(%releases)){
			next if exists $returnvalue{$rpath};
			$returnvalue{$rpath}=$releases{$rpath};
			$returnvalue{$rpath}=~s/,.*$//;
			next unless($returnvalue{$rpath} =~ /\.0+$/);
			foreach my $subpath ('lib','lib/lib64'){
				my $ext;
				$^O=~/hpux/i and $ext = 'sl' or $ext='so';
				my $filename="$rpath/$subpath/libpcr.$ext";
				-f $filename or next;
				my ($maj,$min,$cor,$patch)=SAPDB::Install::BuildInfo::GetBuild($filename);
				my $release = "$maj.$min.$cor.$patch";
				$release =~ /\d/ and $returnvalue{$rpath}=$release and last;
			}	
		}
	}
	return %returnvalue;
}


sub readRuntimesWin{
	my @paths=readSubKeys(0,"SOFTWARE\\SAP\\SAP DBTech\\Runtime");
	my %returnhash;
	foreach my $path (@paths){
		my $origpath=$path;
		$path =~ s/\\/\//g;
		my %values = readValues(0,"SOFTWARE\\SAP\\SAP DBTech\\Runtime\\$origpath");
		my $release=$values{''};
		$release=~s/,.*$//;
		$returnhash{$origpath}=$release;
		next if($release =~ /\d/ and $release !~ /\.0+$/);
		my $filename = "$path/pgm/libpcr.dll";
		-f $filename or $filename = "$path/pgm/pgm64/libpcr.dll";
		-f $filename or next;
		my ($maj,$min,$cor,$patch)=SAPDB::Install::BuildInfo::GetBuild($filename);
		$release = "$maj.$min.$cor.$patch";
		$release  =~ /\d/ and $returnhash{$origpath}=$release;
	}
	return %returnhash;
}


*readRuntimes = 
	$^O =~ /^MsWin/i ? \&readRuntimesWin :
	\&readRuntimesUX;



sub getInstalledReleasesWin{
	my @inst = readSubKeys(0,"SOFTWARE\\SAP\\SAP DBTech\\Installations");
	($#inst==-1) and return undef;
	my %rel;
	foreach my $inst (@inst){
		my %hash=readValues(0,"SOFTWARE\\SAP\\SAP DBTech\\Installations\\$inst");
		$_=$hash{'VersionID'};
		/^(..)(..)(..)(..)$/ or print2stderr("getInstalledReleasesWin(): wrong version format\n");
		my $major=hex($1);
		my $minor=hex($2);
		my $corr=hex($3);
		my $patch=hex($4); 
		$inst =~ s/\\/\//g;
		$rel{$inst}="$major.$minor.$corr.$patch";
	}
	foreach my $dbroot (keys %rel){
		my $release=getRelease("$dbroot/pgm/kernel.exe");
		if($release){
			$rel{$dbroot}=$release;
		}
    }
	return %rel;
}

*getInstalledReleases = 
	# return all installed serverreleases in a hash -> key = instroot 
	$^O =~ /^MsWin/i ? \&getInstalledReleasesWin :
	\&getInstalledReleasesUX;


sub readGlobals{
	-f $SAPDB::Install::Values::glob_path or return undef;
	my %globs = readini($SAPDB::Install::Values::glob_path)  or
						print2stderr("can\'t read globals: $!\n");
	return $globs{'Globals'};
}



#sub return paths of independent data and programs (list of 2 elements)
sub readIndepPathUX{
    if(-f $SAPDB::Install::Values::glob_path){
		my $globs = readGlobals();
		return $globs->{'IndepData'},$globs->{'IndepPrograms'};
	}
	else{
		-f $SAPDB::Install::Values::ini_path or return undef;
		my %hash = readini($SAPDB::Install::Values::ini_path) or 
						print2stderr("cannot read SAP_DBTech.ini: $!\n");
		return $hash{'Globals'}{'IndepData'}, $hash{'Globals'}{'IndepPrograms'};
	}
}


sub readIndepPathWin{
    my $data_path;
    my $prog_path;
    my %hash=readValues(0,"SOFTWARE\\SAP\\SAP DBTech");
	$hash{'IndepData'}=~s/\\/\//g;
	$hash{'IndepPrograms'}=~s/\\/\//g;
	return $hash{'IndepData'}, $hash{'IndepPrograms'};
}


sub createUninstallEntry{
	$^O !~ /mswin/i && return 1;
	my $rc = 1;
	my ($name,$command) = @_;
	my $keyname = 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\SAP DB (ALL)';
	createKey(0,$keyname);
	my $key;
	(RegOpenKeyEx(&HKEY_LOCAL_MACHINE, $keyname, 0, &KEY_SET_VALUE, $key ) == 0) 
	or  print2stderr("createUninstallEntry(): cannot open HKEY_LOCAL_MACHINE\\$keyname: $!\n") and return 0;
	(RegSetValueEx($key,'DisplayName',0,&REG_EXPAND_SZ,$name,0)==0) or print2stderr("createUninstallEntry(): cannot set value \"DisplayName\"\n") and $rc=0;
	(RegSetValueEx($key,'UninstallString',0,&REG_EXPAND_SZ,$command,0)==0) or print2stderr("createUninstallEntry(): cannot set value \"UninstallString\"\n") and $rc=0;
	(RegCloseKey( $key ) == 0) or $SAPDB::Install::Values::log->SetMsg("Can't close registry key \"HKEY_LOCAL_MACHINE\\$keyname\": $!\n") and $rc=0;
	return $rc;	
}

sub removeUninstallEntry{
	$^O !~ /mswin/i && return 1;
	my $keyname = 'SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\SAP DB (ALL)';
	return removeKey({'name' => 'HKEY_LOCAL_MACHINE', 'handle' => &HKEY_LOCAL_MACHINE},$keyname,2);
}



sub setRenamedFiles{
	$^O !~ /mswin/i && return 0;
	my @files = @_;
	my @tmp;
	foreach my $file (@files){
		$file =~ s/\//\\/g;
		push @tmp,'\??\\'.$file;
		push @tmp,''; 
	}
	@files = @tmp;
	my $keyname = 'SYSTEM\CurrentControlSet\Control\Session Manager';
	my $valuename = 'PendingFileRenameOperations';	
	my $key;
	my %values = readValues(&HKEY_LOCAL_MACHINE, $keyname);
	if(exists $values{$valuename} and defined $values{$valuename}){
		my @existingfiles = @{$values{$valuename}};
		push @files,@existingfiles;
	}
	(RegOpenKeyEx(&HKEY_LOCAL_MACHINE, $keyname, 0, &KEY_SET_VALUE, $key ) == 0) 
		or  print2stderr("setRenamedFiles(): cannot open HKEY_LOCAL_MACHINE\\$keyname: $!\n")
		and return 0; 	
	(RegSetValueEx($key,$valuename,0,&REG_MULTI_SZ,\@files,0) == 0)
		or print2stderr("setRenamedFiles(): cannot set value \"$valuename\"\n")
		and return 0;
	(RegCloseKey( $key ) == 0)
		or $SAPDB::Install::Values::log->SetMsg("Can't close registry key \"HKEY_LOCAL_MACHINE\\$keyname\": $!\n")
		and return 0;
	return 1;
}


sub readIndepPath{
	if(	$SAPDB::Install::Values::indep_prog_path =~ /\S/ and 
		$SAPDB::Install::Values::indep_data_path =~ /\S/){
		return ($SAPDB::Install::Values::indep_data_path,$SAPDB::Install::Values::indep_prog_path);
	}
	my @result;
	if($^O =~ /mswin/i){
		@result = readIndepPathWin(); 
	}
	else{
		@result = readIndepPathUX();
	}
	($SAPDB::Install::Values::indep_data_path,$SAPDB::Install::Values::indep_prog_path) = @result;
	return @result;
}

1;