#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/b_07/sys/src/install/perl/SAPDB/Install/Migrate/Registry/PackageScripts.pm#1 $
# $DateTime: 2003/11/20 17:48:59 $
# $Change: 57359 $
#
# Desc: 


package SAPDB::Install::Migrate::Registry::PackageScripts;

$VERSION = 1.01;

sub BEGIN {
      $DEBUG=0;
	  @ISA = ('SAPDB::Install::Exporter');
      @EXPORT = ('BaseScript','$UtilScript','$KernelScript');

	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages=(
		
	);
	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                print join ("\n", $repo->GetErr)."\n";
                die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	  } 
}


$BaseScript = 'import SAPDB::Install::StdIO;
import SAPDB::Install::System;
import SAPDB::Install::Registry;
import SAPDB::Install::Tools;
import SAPDB::Install::SetUser;
import SAPDB::Install::Cwd;
sub unregisterWin{
	return 1;
}

sub unregisterUX{
	return 1;
}


*unregister =           $^O =~ /^MsWin/i ? \\&unregisterWin :
        \\&unregisterUX;


sub preuninstall{

}

sub postuninstall{
	my $data;
	my $prog;
	foreach my $rhPath (@{$regpackobj->Pathes}){
		my %hPath=%$rhPath;	
		if($hPath{name} eq "independent data path"){ 
			$data=$hPath{value};
			next;
		}
		if($hPath{name} eq "independent program path"){ 
			$prog=$hPath{value};
		}
	}
	
	# remove sapdb installer registry files
	-d $data or print2stderr("data path \\"$data\\" not found\\n") and return;
	opendir(DH,"$data/config/install") or print2stderr("cannot open dir \\"$data/config/install\\"\\n");
	foreach (readdir(DH)){
		if(/INSTREG/i or /SAPDB_history/i or /^LIST/i or /^SCRIPT/i){
			 -f "$data/config/install/$_" and (unlink("$data/config/install/$_") or print2stderr("cannot delete file \\"$data/config/install/$_\\": $!\\n"));
		}	
	}
	closedir(DH);
	
	# remove logs and traces  
	opendir(DH,"$data/wrk") or print2stderr("cannot open dir \\"$data/wrk\\"\\n");
	foreach (readdir(DH)){
		if(/vserver.prot/ or /\\.log$/i or /NI_TRACEFILE/ or /irtrace.shm/ or /\\.prt$/i or /\\.mdf$/i or /\\.trc$/i or /sapdb_installer_trace/){
			-f "$data/wrk/$_" and (unlink("$data/wrk/$_") or print2stderr("cannot delete file \\"$data/wrk/$_\\": $!\\n"));
		}	
	}
	closedir(DH);
	
	#remove appldiag files
	foreach (grep {/appldiag$/} find("$data/wrk","f")){
		unlink or print2stderr("cannot remove file \\"$_\\"\\n");
	} 
	
	
	# remove uninstall logfiles 
	opendir(DH,"$prog/install") or print2stdout("cannot open dir \\"$prog/install\\"\\n");
	foreach (readdir(DH)){
		if(/\\.log/){
			-f "$prog/install/$_" and unlink("$prog/install/$_") or print2stderr("cannot remove file \\"$prog/install/$_\\"\\n"); 
		}
	}
	closedir(DH);
	
	defined $SAPDB::Install::Values::log &&
	$SAPDB::Install::Values::log->LogPath($SAPDB::Install::CallerDir);

	deleteSAPDBTech();
	removeFromSysPath("$prog/bin;$prog/pgm") if $^O =~ /mswin/i;
	
	
	unless($^O =~ /mswin/i){
		my $dcom_ini = "/usr/spool/sql/ini/Registry_dcom.ini";
		-f $dcom_ini and (unlink($dcom_ini) or print2stderr("cannot remove file \\"$decom_ini\\"\\n"));
		my ($rc,$removed,$unremoved) = removeEmptyDirs("/usr/spool/sql");
		foreach $dir (@$unremoved){
			print2stderr("cannot remove directory \\"$dir\\"\\n");
		}
	}
	
}
1;';



$UtilScript = 'import SAPDB::Install::StdIO;
import SAPDB::Install::System;
import SAPDB::Install::Registry;
import SAPDB::Install::Tools;

sub unregisterWin{
    my $path = $regpackobj->Path;    
	$ENV{PATH}="$path\\\\bin;$path\\\\pgm;$ENV{PATH}";
	$path=~s/\\//\\\\/g;
	
	my $success = 0;

	sub xservertest{
		my ($text) = @_;
		$text =~ /removed\\ssuccessfully/s and $success = 1 and return 1;
		return 0;
	}
	callsystem("x_server stop",sub{return 1;},1);
	callsystem("x_server remove",\\&xservertest,1);
	$success or print2stderr("cannot remove x_server service\\n");
	
}

sub unregisterUX{
	
}


*unregister =           $^O =~ /^MsWin/i ? \\&unregisterWin :
        \\&unregisterUX;


sub preuninstall{

}

sub postuninstall{
	my ($data,$prog)=readIndepPath();
	opendir(DH,"$data/wrk") or print2stderr("cannot open dir \\"$data/wrk\\"\\n");
	foreach (readdir(DH)){
		if(/dbmsrv.prt/ or /xserver.p/){
			-f "$data/wrk/$_" and (unlink("$data/wrk/$_") or print2stderr("cannot delete file \\"$data/wrk/$_\\": $!\\n"));
		}	
	}
	closedir(DH);
}

1;';




$KernelScript = 'import SAPDB::Install::StdIO;
import SAPDB::Install::System;
import SAPDB::Install::Registry;
import SAPDB::Install::Tools;
import SAPDB::Install::SetUser;
import SAPDB::Install::Values;
import SAPDB::Install::Trace;

sub unregisterWin{
	($indep_data,$indep_prog) = readIndepPath();
	print2stdout("unregister ".$regpackobj->Name." ".$regpackobj->Version."\\n");
	my $path=$regpackobj->Path;
	sub checkfunc{
		return 1; # ignore all errors while callsystem
	}
	*func=\\&checkfunc;
	#my $path = $SAPDB::Install::SRV::deppath{value};
	$path=~s/\\//\\\\/g;
	my $indep_path = $indep_prog;
	$indep_path =~ s/\\//\\\\/g;
	$ENV{PATH}="$path\\\\bin;$path\\\\pgm;$indep_path\\\\bin;$indep_path\\\\pgm;$ENV{PATH}";
	{
		my $callstring = "xregcomp -u %\\"$path/pgm/dbpinstall%\\"";
		$callstring=~s/\\//\\\\/g;
		$callstring=~s/%/\\\\/g;	
		callsystem($callstring,*func,1);
		$callstring = "xregcomp -u %\\"$indep_prog/lib/livecachedbg%\\"";
		$callstring=~s/\\//\\\\/g;
		$callstring=~s/%/\\\\/g;	
		callsystem($callstring,*func,1);
    }	
	{
		my $callstring="dbmcli -R \\"$path\\" inst_unreg ";
		$callstring=~s/\\//\\\\/g;
		$callstring=~s/%/\\\\/g;
		callsystem($callstring,*func,1);
    }
}



sub unregisterUX{
	($indep_data,$indep_prog) = readIndepPath();
	print2stdout("unregister ".$regpackobj->Name." ".$regpackobj->Version."\\n");
	sub checkfunc{
		return 1;
	}
	my $path=$regpackobj->Path;
	*func=\\&checkfunc;	
	callsystem("$path/bin/dbmcli -s inst_unreg $path",*func,1);
    if(-d "$deppath{value}/lib/lib64"){
		callsystem("$path/bin/xregcomp -u $path/lib/lib64/dbpinstall",*func,1);
    }
    else{
		callsystem("$path/bin/xregcomp -u $path/lib/dbpinstall",*func,1);
    }	
}

*unregister =		$^O =~ /^MsWin/i ? \\&unregisterWin :
	\\&unregisterUX;



sub preuninstall{
	my %dbroots = getInstances();
	my $found=0;
	foreach my $DB	(keys(%dbroots)){
		if(normalizePath($dbroots{$DB}) eq normalizePath($regpackobj->Path)){
			print2stderr("found instance $DB \\n");
			$found=1;
		}
	}
	if($found){
		print2stderr("cannot remove package \\"".$regpackobj->Name."\\": first you have to remove all instances\\n");
		diesoft("fatal error");
	}			
}


sub postuninstall{
	
	# remove file Registry.dcom
	my $regcomp_file = $regpackobj->Path."/wrk/Registry.dcom";
	if(-l $regcomp_file){ 
		my $filename = readlink($regcomp_file);
		-f $filename && unlink($filename) || print2stderr("cannot remove file \\"$filename\\"\\n");
		unlink($regcomp_file) || print2stderr("cannot remove link \\"$regcomp_file\\"\\n");
	}
	else{
		-f $regcomp_file && (unlink($regcomp_file) || print2stderr("cannot remove file \\"$regcomp_file\\"\\n"));
	}


	# remove python byte code
	foreach my $python_path ($regpackobj->Path."/lib/python1.5",$regpackobj->Path."/env"){
		if (-d $python_path){
			foreach (grep {/\\.pyc$/} find($python_path,"f")){
				unlink || print2stderr("cannot remove file \\"$_\\"\\n");
			}		
		}
		
	}
}
1;';

1;