#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/b_07/sys/src/install/perl/SAPDB/Install/Migrate/Registry.pm#1 $
# $DateTime: 2003/11/20 17:48:59 $
# $Change: 57359 $
#
# Desc: 


package SAPDB::Install::Migrate::Registry;

$VERSION = 1.01;

sub BEGIN {
      $DEBUG=0;
	  @ISA = ('SAPDB::Install::Exporter');
      @EXPORT = ('migrateReg');

	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages=(
		'StdIO',
		'Values',
		'Registry',
		'Tools',
		'MD5Sum',
		'System',
		'Trace',
		'Migrate::Registry::PackageScripts'
	);
	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                print join ("\n", $repo->GetErr)."\n";
                die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	  } 
}



my $data;
my $prog;	


sub getfilename{
	my ($fileRegDir,$path,$package,$type,$new) = @_; # $type = SCRIPT | LIST (default); $new -> bool, if true no fallback
	($type eq 'SCRIPT' or $type eq 'DESC') or $type = 'LIST';
	my $tmp_path=$path; # remember for fallback (without normalization of path for windows)  
	if($^O=~/mswin/i){
		# normalize windows path
		$path=~s/\\/\//g;   # all backslashes to slashes
		$path=~tr/A-Z/a-z/; # change all to lower case 
	}
	my $filename = "$fileRegDir/$type".MD5Str($path);
	unless($new){
		unless(-f $filename){
			TraceMsg("FileList \"$filename\" dont exist - no try fallback:\n",4,\$DEBUG);
			my $found = 0; 
			foreach my $fallbackname (
					"$fileRegDir/$type".MD5Str("$path$package"),
					"$fileRegDir/$type".MD5Str($tmp_path),
					"$fileRegDir/$type".MD5Str("$tmp_path$package")
									){

				if(-f $fallbackname){
					$filename = $fallbackname;
					$found = 1;
					last;
				}
			}
			unless($found){
				TraceMsg("FileList dont exist\n",4,\$DEBUG);
				if($^O =~ /mswin/i and $type eq 'LIST' and not -f $filename){
					TraceMsg("try fallback ... \n",4,\$DEBUG);
					my $test_file = $package =~ /Independent/ ? 'pgm/serv.exe' : 'pgm/dbmsrv.exe';
					TraceMsg("test file = $test_file\n",4,\$DEBUG);
					my $pattern = '^'.$type.'[a-h0-9]{32}$';	
					opendir(DH,$fileRegDir) or return undef;
					my @list_files = grep {-f "$fileRegDir/$_" and /$pattern/} readdir(DH);
					closedir(DH);
					$#list_files == -1 and TraceMsg("no possible list in $fileRegDir found\n",4,\$DEBUG) and return undef;		
					my $real_md5sum = MD5Sum("$path/$test_file");		
					$real_md5sum or (TraceMsg("cannot get md5sum of $path/$test_file\n",4,\$DEBUG) and return undef);
					foreach my $list (@list_files){
						TraceMsg("test list $list\n",4,\$DEBUG);
						my %md5sums = readFileList("$fileRegDir/$list");
						my $key_found = 0;
						foreach my $key (keys(%md5sums)){
							my $new_pattern = '^'.$test_file.'$';
							if($key =~ /$new_pattern/i){
								$key_found = 1;
								TraceMsg("file $key found in list $list\n",4,\$DEBUG);
								$test_file = $key;
								last;
							}				
						}
						$key_found || next;
						if($real_md5sum eq $md5sums{$test_file}){
							TraceMsg("md5sum match - $list is our list\n",4,\$DEBUG);
							return "$fileRegDir/$list";
						}
						else{
							TraceMsg("md5sum don\'t match - $list isn\'t our list\n",4,\$DEBUG);
						}
					}
				}
				return;
			}
			TraceMsg("ListFile found\n",4,\$DEBUG);
		}
	} 
	
	return $filename;
}



sub readFileData{
	my ($path,$packagename)=@_;	
	# try to get file und md5 data
	unless(-d $data){
		my $text;
		$data =~ /\S+/ and $text="($data)";
		$DEBUG && print "no indep data path found $text\n";
		return;
	}
	my $regpath="$data/config/install";
	my $md5name=getfilename($regpath,$path,$packagename);#'LIST'.MD5Str($path);
	defined $md5name or return;
	unless(-f $md5name)
	{
		TraceMsg("listfile  \"$md5name\" not found\n",3,\$DEBUG);
		return;
	}
	my %list = readFileList($md5name);
	defined %list || TraceMsg("could not read any files/md5sums\n",3,\$DEBUG);	
	return %list;
}


sub migrateDependent{
	my ($instRegistry)=@_;
	my $packagename='Database Kernel';
	my $old_packagename='Server Software';
	#get all registered instroots
	my %instinfo = getInstalledReleases();
	exists $instinfo{0}  and (not defined $instinfo{0} or $instinfo{0} eq '') and return 0;
	exists $instinfo{''}  and (not defined $instinfo{''} or $instinfo{''} eq '') and return 0;
	defined %instinfo or $SAPDB::Install::Values::log->SetMsg("MSG: no installation data to migrate for \"Database Kernel\"\n") and return 0;
	my @instroots = keys(%instinfo);  
	my %regPathes=$instRegistry->getInstallPathes($packagename);
	my @regpathes = keys(%regPathes);
	my @tmp;
	my %origtab;
	foreach my $path (@instroots){
		my $orig=$path;
		if(release2num($instinfo{$path}) < 7020404){
			$SAPDB::Install::Values::log->SetMsg("WRN: old DBROOT installation found\n");
			$SAPDB::Install::Values::log->SetMsg("$instinfo{$path} in \"$path\" ignored\n");
			next;
		}
		normalizePath(\$path);
		push @tmp,$path;
		$origtab{$path}=$orig;
	}
	my @unregistered = minus(\@tmp,\@regpathes);
	

	my @old_changed;
	
	foreach my $registered_path (keys(%instinfo)){
		my $path = $registered_path;
		normalizePath(\$path);
		
		
		# it's already inside install registry
		TraceMsg("test if it exists in registry\n",4,\$DEBUG);
		exists $regPathes{$path} or next;	
		
		# it's older than 7.4
		TraceMsg("test ".$instinfo{$registered_path}." > 7.4\n",4,\$DEBUG);
		release2num($instinfo{$registered_path}) > release2num('7.4.00.00') and next;		
		
		# version number has been changed
		TraceMsg("test ".$instinfo{$registered_path}." != ".$regPathes{$path}."\n",4,\$DEBUG); 
		release2num($instinfo{$registered_path}) == release2num($regPathes{$path}) and next; 
		push @old_changed,$path;
	
	}
	
	
	foreach my $path (@tmp){
		TraceMsg("INSTROOT: $path\n",4,\$DEBUG);
	}
	foreach my $path (@regpathes){
		TraceMsg("InstRegistry: $path\n",4,\$DEBUG);
	}
	foreach my $path (@unregistered){
		TraceMsg("DIFF: $path\n",4,\$DEBUG);
	}
	
	foreach my $path (@old_changed){
		TraceMsg("OLD CHANGED: $path\n",4,\$DEBUG);
	}
	
		
	if($#unregistered == -1 && $#old_changed == -1){
		TraceMsg("no unregistered instroot found\n",3,\$DEBUG);
		$SAPDB::Install::Values::log->SetMsg("MSG: no installation data to migrate\n") and return 0;
	}
	
	foreach my $path (@old_changed){
		TraceMsg("update server installation data for INSTROOT \"$path\"\n",3,\$DEBUG);
		$SAPDB::Install::Values::log->SetMsg("MSG: update server installation data for INSTROOT \"$path\"\n");
		local $regpackobj=$instRegistry->getPackage($packagename,$path);
		my %filelist=readFileData($path,$old_packagename);
		defined %filelist and $regpackobj->FileList(\%filelist);
		defined %filelist && TraceMsg("filelist found\n",3,\$DEBUG);
		my $ext = '.exe' if ($^O=~/mswin/i);
		my $testfile = "$path/pgm/kernel$ext";
		if(-f $testfile){
			TraceMsg("kernel found\n",4,\$DEBUG);
			$regpackobj->Valid(1);
			unless($^O =~ /mswin/i){
				my @statbuf = stat($testfile);
				my ($uid,$gid) = ($statbuf[4],$statbuf[5]);
				if(defined $uid){
					my $username = (getpwuid($uid))[0];
					if($username =~ /\S/){
						$regpackobj->User($username);
					} 
				}
				if(defined $gid){
					my $groupname = (getgrgid($gid))[0];
					if($groupname =~ /\S/){
						$regpackobj->Group($groupname);
					}
				}
			}
		}
		else{
			TraceMsg("kernel not found\n",4,\$DEBUG);
			$regpackobj->Valid(0);
		}
		TraceMsg("set Version to \"$instinfo{$origtab{$path}}\"\n",4,\$DEBUG);
		$regpackobj->Version($instinfo{$origtab{$path}});
		$regpackobj->Require(["Server Utilities >= ".$instinfo{$origtab{$path}}]);
		$regpackobj->Script(\$SAPDB::Install::Migrate::Registry::PackageScripts::KernelScript);
		$regpackobj->setValues;
	}
	
	
	foreach my $path (@unregistered){
		TraceMsg("migrate server installation data for INSTROOT \"$path\"\n",3,\$DEBUG);
		$SAPDB::Install::Values::log->SetMsg("MSG: migrate server installation data for INSTROOT \"$path\"\n");
		local $regpackobj=$instRegistry->newPackage($packagename,$path);
		my %filelist=readFileData($path,$old_packagename);
		defined %filelist and $regpackobj->FileList(\%filelist);
		defined %filelist && TraceMsg("filelist found\n",3,\$DEBUG);
		my $ext = '.exe' if ($^O=~/mswin/i);
		my $testfile = "$path/pgm/kernel$ext";
		if(-f $testfile){
			TraceMsg("kernel found\n",4,\$DEBUG);
			$regpackobj->Valid(1);
			unless($^O =~ /mswin/i){
				my @statbuf = stat($testfile);
				my ($uid,$gid) = ($statbuf[4],$statbuf[5]);
				if(defined $uid){
					my $username = (getpwuid($uid))[0];
					if($username =~ /\S/){
						$regpackobj->User($username);
					} 
				}
				if(defined $gid){
					my $groupname = (getgrgid($gid))[0];
					if($groupname =~ /\S/){
						$regpackobj->Group($groupname);
					}
				}
			}
		}
		else{
			TraceMsg("kernel not found\n",4,\$DEBUG);
			$regpackobj->Valid(0);
		}
		TraceMsg("set Version to \"$instinfo{$origtab{$path}}\"\n",4,\$DEBUG);
		$regpackobj->Version($instinfo{$origtab{$path}});
		$regpackobj->Require(["Server Utilities >= ".$instinfo{$origtab{$path}}]);
		$regpackobj->Script(\$SAPDB::Install::Migrate::Registry::PackageScripts::KernelScript);
		$regpackobj->setValues;
	}
	return 1;
}


sub migrateIndep{
        my ($instRegistry,@packobjs)=@_;
        my $base_packagename = 'Base';
        my $util_packagename = 'Server Utilities';
        my $old_packagename='Independent Programs';
        my $base_packobj;
        foreach my $packobj (@packobjs){
                if($packobj->Name eq $base_packagename){
                        $base_packobj = $packobj;
                        last;
                }
        }
        defined $base_packobj or return 1;

        unless(-d $prog){
                my $text;
                $prog =~ /\S+/ and $text="($prog)";
                TraceMsg("no independent programs path found $text\n",3,\$DEBUG);
                return 0;
        }
        my $path=$prog;
        normalizePath(\$path);
        my %regPathes=$instRegistry->getInstallPathes($base_packagename);
        my @pathlist=keys(%regPathes);
        my $ext = '.exe' if ($^O=~/mswin/i);
        my $subdir='bin';
        $subdir='pgm'if ($^O=~/mswin/i);
        my $testfile=$path.'/'."$subdir/dbmcli$ext";
        my $release;
        if(-f $testfile){
				TraceMsg("dbmcli found\n",4,\$DEBUG);
                $release = getRelease($testfile);
        }
        else{
				TraceMsg("dbmcli not found\n",4,\$DEBUG);
        }
        
		TraceMsg("real independent program path = $path\n",4,\$DEBUG);
        foreach my $path (@pathlist){
			TraceMsg("registered independent = $path\n",4,\$DEBUG);
        }
        

        if($#pathlist > 0){
                TraceMsg("WRN: more than one indep package\n",3,\$DEBUG);
                $SAPDB::Install::Values::log->SetMsg("WRN: migration: inconsistant registry data: more than one indep package\"\n");
        }
        if(exists $regPathes{$path}){
                TraceMsg("independent path already registered\n",3,\$DEBUG);
                return 1;
        }
        TraceMsg("migrate installation data for independent software\n",3,\$DEBUG);
        unless($#pathlist == -1){
                TraceMsg("WRN: wrong indep package registered\n",4,\$DEBUG);
                $SAPDB::Install::Values::log->SetMsg("WRN: migration: inconsistant registry data: wrong indep package\"\n");
        }
        my $regpackobj=$instRegistry->newPackage($base_packagename,$path);
        $release and $regpackobj->Version($release);
        my %filelist=readFileData($path,$old_packagename);
		$SAPDB::Install::Values::log->SetMsg("migrate installation data for \"$base_packagename\" package\n");
        
		my $util_testfile = "$path/bin/x_server$ext";
		my $util_regpackobj;
		if(-f $util_testfile){
			TraceMsg("testfile for Server Utilities found\n",4,\$DEBUG);
			$util_regpackobj=$instRegistry->newPackage($util_packagename,$path);
            $util_regpackobj->Version($release);
			$util_regpackobj->Require(["Base >= $release"]);
            if(-f $util_testfile){
				$util_regpackobj->Valid(1);
				unless($^O =~ /mswin/i){
					my @statbuf = stat($util_testfile);
					my ($uid,$gid) = ($statbuf[4],$statbuf[5]);
					if(defined $uid){
						my $username = (getpwuid($uid))[0];
						if($username =~ /\S/){
							$util_regpackobj->User($username);
						} 
					}
					if(defined $gid){
						my $groupname = (getgrgid($gid))[0];
						if($groupname =~ /\S/){
							$util_regpackobj->Group($groupname);
						}
					}
				}
			}
			else{
				$util_regpackobj->Valid(0);
			}
			$util_regpackobj->Script(\$SAPDB::Install::Migrate::Registry::PackageScripts::UtilScript);
			$util_regpackobj->setValues;
			$SAPDB::Install::Values::log->SetMsg("migrate installation data for \"$util_packagename\" package\n");
		}

		
		if(defined %filelist){
                my %baselist;
                my %utillist;
                my @base_file_list = keys(%{$base_packobj->FileList});
                my @complete_file_list = keys(%filelist);
                my @util_file_list = minus(\@complete_file_list,\@base_file_list);
                foreach my $file (@base_file_list){
                        exists $filelist{$file} and $baselist{$file} = $filelist{$file};
                }
                foreach my $file (@util_file_list){
                        
						# dont import pcr files into utils file list 
						($file =~ /pcr71/i or $file =~ /libpcr\./i or $file =~ /sqluser\./i) and next;

						# dont import odbc and dbanalyzer files into utils file list 
						$file =~ /sqlod|sqlsp32|odcompr|odbc|dbana|sapdbcbin|sapdbc\.jar/i and next;
						
						exists $filelist{$file} and $utillist{$file} = $filelist{$file};
                }
                if($#util_file_list != -1){
                        TraceMsg("found files for filelist of $util_packagename\n",4,\$DEBUG);
						defined $util_regpackobj or $util_regpackobj=$instRegistry->newPackage($util_packagename,$path);
                        $util_regpackobj->FileList(\%utillist);
                        $util_regpackobj->Version($release);
						$util_regpackobj->Require(["Base >= $release"]);
                        if(-f $util_testfile){
							$util_regpackobj->Valid(1);
							unless($^O =~ /mswin/i){
								my @statbuf = stat($util_testfile);
								my ($uid,$gid) = ($statbuf[4],$statbuf[5]);
								if(defined $uid){
									my $username = (getpwuid($uid))[0];
									if($username =~ /\S/){
										$util_regpackobj->User($username);
									} 
								}
								if(defined $gid){
									my $groupname = (getgrgid($gid))[0];
									if($groupname =~ /\S/){
										$util_regpackobj->Group($groupname);
									}
								}
							}
						}
						else{
							$util_regpackobj->Valid(0);
						}
						$util_regpackobj->Script(\$SAPDB::Install::Migrate::Registry::PackageScripts::UtilScript);
						$util_regpackobj->setValues;
						$SAPDB::Install::Values::log->SetMsg("migrate installation data for \"$util_packagename\" package\n");
				}
                $regpackobj->FileList(\%baselist);
        }

        if(-f $testfile){
                $regpackobj->Valid(1);
				unless($^O =~ /mswin/i){
					my @statbuf = stat($testfile);
					my ($uid,$gid) = ($statbuf[4],$statbuf[5]);
					if(defined $uid){
						my $username = (getpwuid($uid))[0];
						if($username =~ /\S/){
							$regpackobj->User($username);
						} 
					}
					if(defined $gid){
						my $groupname = (getgrgid($gid))[0];
						if($groupname =~ /\S/){
							$regpackobj->Group($groupname);
						}
					}
				}
		}
        else{
                $regpackobj->Valid(0);
        }
		$regpackobj->Script(\$SAPDB::Install::Migrate::Registry::PackageScripts::BaseScript);
        $regpackobj->setValues;
        return 1;
}

sub migrateReg{
        my ($instRegistry,@packobjs)=@_;
        defined $instRegistry or $SAPDB::Install::Values::log->SetMsg("WRN: install registry not defined\n") and return 0;
        ($data,$prog)=readIndepPath();
        migrateIndep($instRegistry,@packobjs);
        migrateDependent($instRegistry);
        return 1;
}

1;