#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/b_07/sys/src/install/perl/SAPDB/Install/Migrate/DBRegistrations.pm#1 $
# $DateTime: 2003/11/20 17:48:59 $
# $Change: 57359 $
#
# Desc: 


package SAPDB::Install::Migrate::DBRegistrations;

$VERSION = 1.01;

sub BEGIN {
      $DEBUG=0;
	  @ISA = ('SAPDB::Install::Exporter');
      @EXPORT = ('migrateDBRegistrations');

	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages=(
		'StdIO',
		'Values',
		'Registry',
		'Tools',
		'MD5Sum',
		'System',
		'Trace',
	);
	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval ("SAPDB::Install::$package", 1.01)) {
                print join ("\n", $repo->GetErr)."\n";
                die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	  } 
}


sub migrateDBRegistrations{
	my ($instPath) = @_;
	return if $^O =~ /mswin/i;
	my ($indep_data,$indep_prog) = readIndepPath();
	my $db_reg_ini = $indep_data.'/config/Databases.ini';
	
	my %ini_data = readini($ini_path) if -f ($ini_path);
	my $old_dbs = {};
	if(defined %ini_data and exists $ini_data{'Databases'} and ref($ini_data{'Databases'}) eq 'HASH'){
		$old_dbs = $ini_data{'Databases'}; 
	} 
	
	%ini_data = ();

	%ini_data = readini($db_reg_ini) if -f ($db_reg_ini);
	my $new_dbs = {};
	if(defined %ini_data and exists $ini_data{'Databases'} and ref($ini_data{'Databases'}) eq 'HASH'){
		$new_dbs = $ini_data{'Databases'}; 
	}

	my @dbs2mig;
	foreach my $db (keys(%$old_dbs)){
		next if $db =~ /^[\._]/;
		if($old_dbs->{$db} eq $instPath){
			push @dbs2mig,$db; 
		}
	}
	my @already_migrated;
	foreach my $db (keys(%$new_dbs)){
		next if $db =~ /^[\._]/;
		if($new_dbs->{$db} eq $instPath){
			push @already_migrated,$db; 
		}
	}	
	my @migrate_now = minus(\@dbs2mig,\@already_migrated);
	
	if($#migrate_now > -1){
		my %db_reg;
		foreach my $db (@migrate_now){
			$SAPDB::Install::Values::log->SetMsg("MSG: add new registration of instance $db\n");
			$db_reg{$db} = $instPath; 	
		}
		writeini($db_reg_ini,{'add_key' => {'Databases' => \%db_reg}});	
	}

	if($#dbs2mig > -1){
		my %db_reg;
		foreach my $db (@dbs2mig){
			$db_reg{$db} = $instPath;
			$SAPDB::Install::Values::log->SetMsg("MSG: remove old registration of instance $db\n");
 		}
		writeini($ini_path,{'delete_key' => {'Databases' => \%db_reg}});	
	}
}

1;