#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/b_07/sys/src/install/perl/SAPDB/Install/MD5Sum.pm#1 $
# $DateTime: 2003/11/20 17:48:59 $
# $Change: 57359 $
#
# Desc: 


package SAPDB::Install::MD5Sum;


sub import {
	local $SAPDB::Install::Exporter::ExportLevel = 1;
	SAPDB::Install::Exporter::import (@_);

	bootstrap SAPDB::Install::MD5Sum;
}


sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ('MD5Sum', 'MD5Str');
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages= (
		'Exporter'
	);

	foreach my $package (@neededPackages) {
		unless (defined
		$repo->Eval ("SAPDB::Install::$package", 1.01)) {
			print join ("\n", $repo->GetErr)."\n";
			die;
		}
		import ("SAPDB::Install::$package"); 
	}
}


sub AUTOLOAD {
	die "cannot load symbol ".$AUTOLOAD."\n"
		unless ($AUTOLOAD =~ "bootstrap");

	require DynaLoader;
	push @ISA, 'DynaLoader';
	bootstrap SAPDB::Install::MD5Sum;
}

#
# main
#
sub main {
        return (SAPDB::Install::MD5Sum::Test::main (@_));
}

package SAPDB::Install::MD5Sum::Test;

$DEBUG = 0;

sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ();
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Getopt::Long'
	);

	foreach my $package (@neededPackages) {
		unless (defined $repo->Eval
		("SAPDB::Install::$package", 1.01)) {
			print join ("\n", $repo->GetErr)."\n";
			die;
		}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	}
}

sub main {
	my ($filename) = @_;

	unless (defined $filename) {
		print "MD5Sum <filename>\n";
		return 0;
	}

	my $md5sum = SAPDB::Install::MD5Sum::MD5Sum ($filename);
	print $filename.": ".$md5sum."\n";

	return 0;
}

1;

