#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/b_07/sys/src/install/perl/SAPDB/Install/Instance/Check/Instances.pm#1 $
# $DateTime: 2003/11/20 17:48:59 $
# $Change: 57359 $
#

package SAPDB::Install::Instance::Check::Instances;

sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ();
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Instance::Base',
		'Instance::Check::Conditions'
	);

	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval 
		("SAPDB::Install::$package", 1.01)) {
                	print join ("\n", $repo->GetErr)."\n";
                	die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	  } 
}

push @ISA, 
	'SAPDB::Install::Instance::Base',
	'SAPDB::Install::Instance::Check::Conditions';

sub instances {
	my ($self) = @_;
	my $dbm = $self->{dbm};

	#
	# find out instance type if not already known
	#
	unless (defined $self->{'instancetype'}) {
		my $rc = $self->conditions ();
		return undef unless (defined $rc && $rc == 0);
	}

	$self->set_errorstate ('ERROR');
	$self->msgbegin ("looking for running instances");	
	$self->msg0 ("looking for running instances...\n");
	$self->{'running_instances'} = undef;

	my $enum = $dbm->db_enum ();
	unless (defined $enum) {
		$self->msg1 ("error during db_enum\n");
		$self->msg1 ("\n");
		$self->msg1 ($dbm->lastdialog ());
		return undef;
	}

	my $lines = $#{$enum->{'DBNAME'}} + 1;
	if ($lines <= 0) {
		$self->msg1 ("no instances found\n");
		$self->msg1 ("\n");
		$self->msg1 ($dbm->lastdialog ());
		return undef;
	}

	my @running_instances = ();
	for (my $i = 0; $i < $lines; $i++) {
		next unless ($enum->{'STATE'}->[$i] eq 'running');
		next if ($enum->{'DBNAME'}->[$i] eq $self->{'dbname'});
		
		push @running_instances, $enum->{'DBNAME'}->[$i];
	}

	if (($#running_instances + 1) != 0) {
		$self->{running_instances} = \@running_instances;

		$self->msg1 ("found running instances\n");
		foreach (@{$self->{running_instances}}) {
			$self->msg1 ("  ".$_."\n");
		}
	}

	$self->set_errorstate ('OK');
	$self->msgend ();
	return 0;
} 

1;

