#!/usr/bin/perl
#
# $Header: //sapdb/V75/c_00/b_07/sys/src/install/perl/SAPDB/Install/Instance/Check/Finalize/Generic.pm#1 $
# $DateTime: 2003/11/20 17:48:59 $
# $Change: 57359 $
#

package SAPDB::Install::Instance::Check::Finalize::Generic;

sub BEGIN {
	@ISA = ('SAPDB::Install::Exporter');
	@EXPORT = ();
	my $repo = SAPDB::Install::Repository::GetCurrent ();
	my @neededPackages = (
		'Instance::Base',
		'Instance::Check::Common',
		'Instance::Check::DomainUser'
	);

	foreach my $package (@neededPackages) {
	  	unless (defined $repo->Eval 
		("SAPDB::Install::$package", 1.01)) {
                	print join ("\n", $repo->GetErr)."\n";
                	die;
        	}
		SAPDB::Install::Exporter::import ("SAPDB::Install::$package");
	  } 
}

push @ISA, 
	'SAPDB::Install::Instance::Base',
	'SAPDB::Install::Instance::Check::Common',
	'SAPDB::Install::Instance::Check::DomainUser';

#
# finalize check for generic migration strategies
# that means any other then EXTERNAL_CONSISTENT_BACKUP
#
sub finalizecheck {
	my ($self) = @_; 

	my $rc = $self->domainuser ();
	return ($rc);
}

1;

